package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.{
  EbsSnapshotDataEncryptionKeyId,
  EbsGroup,
  EbsUserId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EbsSnapshotConfiguration(
    userIds: Optional[Iterable[EbsUserId]] = Optional.Absent,
    groups: Optional[Iterable[EbsGroup]] = Optional.Absent,
    kmsKeyId: Optional[EbsSnapshotDataEncryptionKeyId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.EbsSnapshotConfiguration = {
    import EbsSnapshotConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.EbsSnapshotConfiguration
      .builder()
      .optionallyWith(
        userIds.map(value =>
          value.map { item =>
            EbsUserId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.userIds)
      .optionallyWith(
        groups.map(value =>
          value.map { item =>
            EbsGroup.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.groups)
      .optionallyWith(
        kmsKeyId.map(value =>
          EbsSnapshotDataEncryptionKeyId.unwrap(value): java.lang.String
        )
      )(_.kmsKeyId)
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.EbsSnapshotConfiguration.ReadOnly =
    zio.aws.accessanalyzer.model.EbsSnapshotConfiguration.wrap(buildAwsValue())
}
object EbsSnapshotConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.EbsSnapshotConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.EbsSnapshotConfiguration =
      zio.aws.accessanalyzer.model.EbsSnapshotConfiguration(
        userIds.map(value => value),
        groups.map(value => value),
        kmsKeyId.map(value => value)
      )
    def userIds: Optional[List[EbsUserId]]
    def groups: Optional[List[EbsGroup]]
    def kmsKeyId: Optional[EbsSnapshotDataEncryptionKeyId]
    def getUserIds: ZIO[Any, AwsError, List[EbsUserId]] =
      AwsError.unwrapOptionField("userIds", userIds)
    def getGroups: ZIO[Any, AwsError, List[EbsGroup]] =
      AwsError.unwrapOptionField("groups", groups)
    def getKmsKeyId: ZIO[Any, AwsError, EbsSnapshotDataEncryptionKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.EbsSnapshotConfiguration
  ) extends zio.aws.accessanalyzer.model.EbsSnapshotConfiguration.ReadOnly {
    override val userIds: Optional[List[EbsUserId]] = zio.aws.core.internal
      .optionalFromNullable(impl.userIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.accessanalyzer.model.primitives.EbsUserId(item)
        }.toList
      )
    override val groups: Optional[List[EbsGroup]] = zio.aws.core.internal
      .optionalFromNullable(impl.groups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.accessanalyzer.model.primitives.EbsGroup(item)
        }.toList
      )
    override val kmsKeyId: Optional[EbsSnapshotDataEncryptionKeyId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kmsKeyId())
        .map(value =>
          zio.aws.accessanalyzer.model.primitives
            .EbsSnapshotDataEncryptionKeyId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.EbsSnapshotConfiguration
  ): zio.aws.accessanalyzer.model.EbsSnapshotConfiguration.ReadOnly =
    new Wrapper(impl)
}
