package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.Name
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteArchiveRuleRequest(
    analyzerName: Name,
    ruleName: Name,
    clientToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.DeleteArchiveRuleRequest = {
    import DeleteArchiveRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.DeleteArchiveRuleRequest
      .builder()
      .analyzerName(Name.unwrap(analyzerName): java.lang.String)
      .ruleName(Name.unwrap(ruleName): java.lang.String)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.DeleteArchiveRuleRequest.ReadOnly =
    zio.aws.accessanalyzer.model.DeleteArchiveRuleRequest.wrap(buildAwsValue())
}
object DeleteArchiveRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.DeleteArchiveRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.DeleteArchiveRuleRequest =
      zio.aws.accessanalyzer.model.DeleteArchiveRuleRequest(
        analyzerName,
        ruleName,
        clientToken.map(value => value)
      )
    def analyzerName: Name
    def ruleName: Name
    def clientToken: Optional[String]
    def getAnalyzerName: ZIO[Any, Nothing, Name] = ZIO.succeed(analyzerName)
    def getRuleName: ZIO[Any, Nothing, Name] = ZIO.succeed(ruleName)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.DeleteArchiveRuleRequest
  ) extends zio.aws.accessanalyzer.model.DeleteArchiveRuleRequest.ReadOnly {
    override val analyzerName: Name =
      zio.aws.accessanalyzer.model.primitives.Name(impl.analyzerName())
    override val ruleName: Name =
      zio.aws.accessanalyzer.model.primitives.Name(impl.ruleName())
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.DeleteArchiveRuleRequest
  ): zio.aws.accessanalyzer.model.DeleteArchiveRuleRequest.ReadOnly =
    new Wrapper(impl)
}
