package zio.aws.accessanalyzer.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class S3BucketAclGrantConfiguration(
    permission: zio.aws.accessanalyzer.model.AclPermission,
    grantee: zio.aws.accessanalyzer.model.AclGrantee
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.S3BucketAclGrantConfiguration = {
    import S3BucketAclGrantConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.S3BucketAclGrantConfiguration
      .builder()
      .permission(permission.unwrap)
      .grantee(grantee.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.S3BucketAclGrantConfiguration.ReadOnly =
    zio.aws.accessanalyzer.model.S3BucketAclGrantConfiguration
      .wrap(buildAwsValue())
}
object S3BucketAclGrantConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.S3BucketAclGrantConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.S3BucketAclGrantConfiguration =
      zio.aws.accessanalyzer.model
        .S3BucketAclGrantConfiguration(permission, grantee.asEditable)
    def permission: zio.aws.accessanalyzer.model.AclPermission
    def grantee: zio.aws.accessanalyzer.model.AclGrantee.ReadOnly
    def getPermission
        : ZIO[Any, Nothing, zio.aws.accessanalyzer.model.AclPermission] =
      ZIO.succeed(permission)
    def getGrantee
        : ZIO[Any, Nothing, zio.aws.accessanalyzer.model.AclGrantee.ReadOnly] =
      ZIO.succeed(grantee)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.S3BucketAclGrantConfiguration
  ) extends zio.aws.accessanalyzer.model.S3BucketAclGrantConfiguration.ReadOnly {
    override val permission: zio.aws.accessanalyzer.model.AclPermission =
      zio.aws.accessanalyzer.model.AclPermission.wrap(impl.permission())
    override val grantee: zio.aws.accessanalyzer.model.AclGrantee.ReadOnly =
      zio.aws.accessanalyzer.model.AclGrantee.wrap(impl.grantee())
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.S3BucketAclGrantConfiguration
  ): zio.aws.accessanalyzer.model.S3BucketAclGrantConfiguration.ReadOnly =
    new Wrapper(impl)
}
