package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.{
  RdsDbClusterSnapshotKmsKeyId,
  RdsDbClusterSnapshotAttributeName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RdsDbClusterSnapshotConfiguration(
    attributes: Optional[Map[
      RdsDbClusterSnapshotAttributeName,
      zio.aws.accessanalyzer.model.RdsDbClusterSnapshotAttributeValue
    ]] = Optional.Absent,
    kmsKeyId: Optional[RdsDbClusterSnapshotKmsKeyId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.RdsDbClusterSnapshotConfiguration = {
    import RdsDbClusterSnapshotConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.RdsDbClusterSnapshotConfiguration
      .builder()
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (RdsDbClusterSnapshotAttributeName
                .unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.attributes)
      .optionallyWith(
        kmsKeyId.map(value =>
          RdsDbClusterSnapshotKmsKeyId.unwrap(value): java.lang.String
        )
      )(_.kmsKeyId)
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.RdsDbClusterSnapshotConfiguration.ReadOnly =
    zio.aws.accessanalyzer.model.RdsDbClusterSnapshotConfiguration
      .wrap(buildAwsValue())
}
object RdsDbClusterSnapshotConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.RdsDbClusterSnapshotConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.accessanalyzer.model.RdsDbClusterSnapshotConfiguration =
      zio.aws.accessanalyzer.model.RdsDbClusterSnapshotConfiguration(
        attributes.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        kmsKeyId.map(value => value)
      )
    def attributes: Optional[Map[
      RdsDbClusterSnapshotAttributeName,
      zio.aws.accessanalyzer.model.RdsDbClusterSnapshotAttributeValue.ReadOnly
    ]]
    def kmsKeyId: Optional[RdsDbClusterSnapshotKmsKeyId]
    def getAttributes: ZIO[Any, AwsError, Map[
      RdsDbClusterSnapshotAttributeName,
      zio.aws.accessanalyzer.model.RdsDbClusterSnapshotAttributeValue.ReadOnly
    ]] = AwsError.unwrapOptionField("attributes", attributes)
    def getKmsKeyId: ZIO[Any, AwsError, RdsDbClusterSnapshotKmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.RdsDbClusterSnapshotConfiguration
  ) extends zio.aws.accessanalyzer.model.RdsDbClusterSnapshotConfiguration.ReadOnly {
    override val attributes: Optional[Map[
      RdsDbClusterSnapshotAttributeName,
      zio.aws.accessanalyzer.model.RdsDbClusterSnapshotAttributeValue.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.attributes())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.accessanalyzer.model.primitives
              .RdsDbClusterSnapshotAttributeName(
                key
              ) -> zio.aws.accessanalyzer.model.RdsDbClusterSnapshotAttributeValue
              .wrap(value)
          })
          .toMap
      )
    override val kmsKeyId: Optional[RdsDbClusterSnapshotKmsKeyId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kmsKeyId())
        .map(value =>
          zio.aws.accessanalyzer.model.primitives
            .RdsDbClusterSnapshotKmsKeyId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.RdsDbClusterSnapshotConfiguration
  ): zio.aws.accessanalyzer.model.RdsDbClusterSnapshotConfiguration.ReadOnly =
    new Wrapper(impl)
}
