package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.RdsDbClusterSnapshotAccountId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RdsDbClusterSnapshotAttributeValue(
    accountIds: Optional[Iterable[RdsDbClusterSnapshotAccountId]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.RdsDbClusterSnapshotAttributeValue = {
    import RdsDbClusterSnapshotAttributeValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.RdsDbClusterSnapshotAttributeValue
      .builder()
      .optionallyWith(
        accountIds.map(value =>
          value.map { item =>
            RdsDbClusterSnapshotAccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.accountIds)
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.RdsDbClusterSnapshotAttributeValue.ReadOnly =
    zio.aws.accessanalyzer.model.RdsDbClusterSnapshotAttributeValue
      .wrap(buildAwsValue())
}
object RdsDbClusterSnapshotAttributeValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.RdsDbClusterSnapshotAttributeValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.accessanalyzer.model.RdsDbClusterSnapshotAttributeValue =
      zio.aws.accessanalyzer.model
        .RdsDbClusterSnapshotAttributeValue(accountIds.map(value => value))
    def accountIds: Optional[List[RdsDbClusterSnapshotAccountId]]
    def getAccountIds: ZIO[Any, AwsError, List[RdsDbClusterSnapshotAccountId]] =
      AwsError.unwrapOptionField("accountIds", accountIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.RdsDbClusterSnapshotAttributeValue
  ) extends zio.aws.accessanalyzer.model.RdsDbClusterSnapshotAttributeValue.ReadOnly {
    override val accountIds: Optional[List[RdsDbClusterSnapshotAccountId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accountIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.accessanalyzer.model.primitives
              .RdsDbClusterSnapshotAccountId(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.RdsDbClusterSnapshotAttributeValue
  ): zio.aws.accessanalyzer.model.RdsDbClusterSnapshotAttributeValue.ReadOnly =
    new Wrapper(impl)
}
