package zio.aws.accessanalyzer.model
import scala.jdk.CollectionConverters.*
sealed trait JobErrorCode {
  def unwrap: software.amazon.awssdk.services.accessanalyzer.model.JobErrorCode
}
object JobErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.accessanalyzer.model.JobErrorCode
  ): zio.aws.accessanalyzer.model.JobErrorCode = value match {
    case software.amazon.awssdk.services.accessanalyzer.model.JobErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.accessanalyzer.model.JobErrorCode.AUTHORIZATION_ERROR =>
      val r = AUTHORIZATION_ERROR
      r
    case software.amazon.awssdk.services.accessanalyzer.model.JobErrorCode.RESOURCE_NOT_FOUND_ERROR =>
      val r = RESOURCE_NOT_FOUND_ERROR
      r
    case software.amazon.awssdk.services.accessanalyzer.model.JobErrorCode.SERVICE_QUOTA_EXCEEDED_ERROR =>
      val r = SERVICE_QUOTA_EXCEEDED_ERROR
      r
    case software.amazon.awssdk.services.accessanalyzer.model.JobErrorCode.SERVICE_ERROR =>
      val r = SERVICE_ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.accessanalyzer.model.JobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.JobErrorCode =
      software.amazon.awssdk.services.accessanalyzer.model.JobErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object AUTHORIZATION_ERROR
      extends zio.aws.accessanalyzer.model.JobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.JobErrorCode =
      software.amazon.awssdk.services.accessanalyzer.model.JobErrorCode.AUTHORIZATION_ERROR
  }
  case object RESOURCE_NOT_FOUND_ERROR
      extends zio.aws.accessanalyzer.model.JobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.JobErrorCode =
      software.amazon.awssdk.services.accessanalyzer.model.JobErrorCode.RESOURCE_NOT_FOUND_ERROR
  }
  case object SERVICE_QUOTA_EXCEEDED_ERROR
      extends zio.aws.accessanalyzer.model.JobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.JobErrorCode =
      software.amazon.awssdk.services.accessanalyzer.model.JobErrorCode.SERVICE_QUOTA_EXCEEDED_ERROR
  }
  case object SERVICE_ERROR extends zio.aws.accessanalyzer.model.JobErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.JobErrorCode =
      software.amazon.awssdk.services.accessanalyzer.model.JobErrorCode.SERVICE_ERROR
  }
}
