package zio.aws.accessanalyzer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Criterion(
    eq: Optional[Iterable[String]] = Optional.Absent,
    neq: Optional[Iterable[String]] = Optional.Absent,
    contains: Optional[Iterable[String]] = Optional.Absent,
    exists: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.Criterion = {
    import Criterion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.Criterion
      .builder()
      .optionallyWith(
        eq.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.eq)
      .optionallyWith(
        neq.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.neq)
      .optionallyWith(
        contains.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.contains)
      .optionallyWith(exists.map(value => value: java.lang.Boolean))(_.exists)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.Criterion.ReadOnly =
    zio.aws.accessanalyzer.model.Criterion.wrap(buildAwsValue())
}
object Criterion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.Criterion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.Criterion =
      zio.aws.accessanalyzer.model.Criterion(
        eq.map(value => value),
        neq.map(value => value),
        contains.map(value => value),
        exists.map(value => value)
      )
    def eq: Optional[List[String]]
    def neq: Optional[List[String]]
    def contains: Optional[List[String]]
    def exists: Optional[Boolean]
    def getEq: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("eq", eq)
    def getNeq: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("neq", neq)
    def getContains: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("contains", contains)
    def getExists: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("exists", exists)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.Criterion
  ) extends zio.aws.accessanalyzer.model.Criterion.ReadOnly {
    override val eq: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.eq())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val neq: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.neq())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val contains: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.contains())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val exists: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.exists())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.Criterion
  ): zio.aws.accessanalyzer.model.Criterion.ReadOnly = new Wrapper(impl)
}
