package zio.aws.accessanalyzer.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    resourceArn: String,
    tags: Map[String, String]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.TagResourceRequest
      .builder()
      .resourceArn(resourceArn: java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (key: java.lang.String) -> (value: java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.TagResourceRequest.ReadOnly =
    zio.aws.accessanalyzer.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.TagResourceRequest =
      zio.aws.accessanalyzer.model.TagResourceRequest(resourceArn, tags)
    def resourceArn: String
    def tags: Map[String, String]
    def getResourceArn: ZIO[Any, Nothing, String] = ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, Map[String, String]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.TagResourceRequest
  ) extends zio.aws.accessanalyzer.model.TagResourceRequest.ReadOnly {
    override val resourceArn: String = impl.resourceArn(): String
    override val tags: Map[String, String] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        (key: String) -> (value: String)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.TagResourceRequest
  ): zio.aws.accessanalyzer.model.TagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
