package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.{Name, AnalyzerArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ApplyArchiveRuleRequest(
    analyzerArn: AnalyzerArn,
    ruleName: Name,
    clientToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.ApplyArchiveRuleRequest = {
    import ApplyArchiveRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.ApplyArchiveRuleRequest
      .builder()
      .analyzerArn(AnalyzerArn.unwrap(analyzerArn): java.lang.String)
      .ruleName(Name.unwrap(ruleName): java.lang.String)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.ApplyArchiveRuleRequest.ReadOnly =
    zio.aws.accessanalyzer.model.ApplyArchiveRuleRequest.wrap(buildAwsValue())
}
object ApplyArchiveRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.ApplyArchiveRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.ApplyArchiveRuleRequest =
      zio.aws.accessanalyzer.model.ApplyArchiveRuleRequest(
        analyzerArn,
        ruleName,
        clientToken.map(value => value)
      )
    def analyzerArn: AnalyzerArn
    def ruleName: Name
    def clientToken: Optional[String]
    def getAnalyzerArn: ZIO[Any, Nothing, AnalyzerArn] =
      ZIO.succeed(analyzerArn)
    def getRuleName: ZIO[Any, Nothing, Name] = ZIO.succeed(ruleName)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ApplyArchiveRuleRequest
  ) extends zio.aws.accessanalyzer.model.ApplyArchiveRuleRequest.ReadOnly {
    override val analyzerArn: AnalyzerArn =
      zio.aws.accessanalyzer.model.primitives.AnalyzerArn(impl.analyzerArn())
    override val ruleName: Name =
      zio.aws.accessanalyzer.model.primitives.Name(impl.ruleName())
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ApplyArchiveRuleRequest
  ): zio.aws.accessanalyzer.model.ApplyArchiveRuleRequest.ReadOnly =
    new Wrapper(impl)
}
