package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.{PolicyDocument, Token, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ValidatePolicyRequest(
    locale: Optional[zio.aws.accessanalyzer.model.Locale] = Optional.Absent,
    maxResults: Optional[Integer] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent,
    policyDocument: PolicyDocument,
    policyType: zio.aws.accessanalyzer.model.PolicyType,
    validatePolicyResourceType: Optional[
      zio.aws.accessanalyzer.model.ValidatePolicyResourceType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyRequest = {
    import ValidatePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyRequest
      .builder()
      .optionallyWith(locale.map(value => value.unwrap))(_.locale)
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .policyDocument(PolicyDocument.unwrap(policyDocument): java.lang.String)
      .policyType(policyType.unwrap)
      .optionallyWith(validatePolicyResourceType.map(value => value.unwrap))(
        _.validatePolicyResourceType
      )
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.ValidatePolicyRequest.ReadOnly =
    zio.aws.accessanalyzer.model.ValidatePolicyRequest.wrap(buildAwsValue())
}
object ValidatePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.ValidatePolicyRequest =
      zio.aws.accessanalyzer.model.ValidatePolicyRequest(
        locale.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        policyDocument,
        policyType,
        validatePolicyResourceType.map(value => value)
      )
    def locale: Optional[zio.aws.accessanalyzer.model.Locale]
    def maxResults: Optional[Integer]
    def nextToken: Optional[Token]
    def policyDocument: PolicyDocument
    def policyType: zio.aws.accessanalyzer.model.PolicyType
    def validatePolicyResourceType
        : Optional[zio.aws.accessanalyzer.model.ValidatePolicyResourceType]
    def getLocale: ZIO[Any, AwsError, zio.aws.accessanalyzer.model.Locale] =
      AwsError.unwrapOptionField("locale", locale)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPolicyDocument: ZIO[Any, Nothing, PolicyDocument] =
      ZIO.succeed(policyDocument)
    def getPolicyType
        : ZIO[Any, Nothing, zio.aws.accessanalyzer.model.PolicyType] =
      ZIO.succeed(policyType)
    def getValidatePolicyResourceType: ZIO[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.ValidatePolicyResourceType
    ] = AwsError.unwrapOptionField(
      "validatePolicyResourceType",
      validatePolicyResourceType
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyRequest
  ) extends zio.aws.accessanalyzer.model.ValidatePolicyRequest.ReadOnly {
    override val locale: Optional[zio.aws.accessanalyzer.model.Locale] =
      zio.aws.core.internal
        .optionalFromNullable(impl.locale())
        .map(value => zio.aws.accessanalyzer.model.Locale.wrap(value))
    override val maxResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: Integer)
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.accessanalyzer.model.primitives.Token(value))
    override val policyDocument: PolicyDocument =
      zio.aws.accessanalyzer.model.primitives
        .PolicyDocument(impl.policyDocument())
    override val policyType: zio.aws.accessanalyzer.model.PolicyType =
      zio.aws.accessanalyzer.model.PolicyType.wrap(impl.policyType())
    override val validatePolicyResourceType
        : Optional[zio.aws.accessanalyzer.model.ValidatePolicyResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.validatePolicyResourceType())
        .map(value =>
          zio.aws.accessanalyzer.model.ValidatePolicyResourceType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyRequest
  ): zio.aws.accessanalyzer.model.ValidatePolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
