package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.{
  RdsDbSnapshotKmsKeyId,
  RdsDbSnapshotAttributeName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RdsDbSnapshotConfiguration(
    attributes: Optional[Map[
      RdsDbSnapshotAttributeName,
      zio.aws.accessanalyzer.model.RdsDbSnapshotAttributeValue
    ]] = Optional.Absent,
    kmsKeyId: Optional[RdsDbSnapshotKmsKeyId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.RdsDbSnapshotConfiguration = {
    import RdsDbSnapshotConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.RdsDbSnapshotConfiguration
      .builder()
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (RdsDbSnapshotAttributeName
                .unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.attributes)
      .optionallyWith(
        kmsKeyId.map(value =>
          RdsDbSnapshotKmsKeyId.unwrap(value): java.lang.String
        )
      )(_.kmsKeyId)
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.RdsDbSnapshotConfiguration.ReadOnly =
    zio.aws.accessanalyzer.model.RdsDbSnapshotConfiguration
      .wrap(buildAwsValue())
}
object RdsDbSnapshotConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.RdsDbSnapshotConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.RdsDbSnapshotConfiguration =
      zio.aws.accessanalyzer.model.RdsDbSnapshotConfiguration(
        attributes.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        kmsKeyId.map(value => value)
      )
    def attributes: Optional[Map[
      RdsDbSnapshotAttributeName,
      zio.aws.accessanalyzer.model.RdsDbSnapshotAttributeValue.ReadOnly
    ]]
    def kmsKeyId: Optional[RdsDbSnapshotKmsKeyId]
    def getAttributes: ZIO[Any, AwsError, Map[
      RdsDbSnapshotAttributeName,
      zio.aws.accessanalyzer.model.RdsDbSnapshotAttributeValue.ReadOnly
    ]] = AwsError.unwrapOptionField("attributes", attributes)
    def getKmsKeyId: ZIO[Any, AwsError, RdsDbSnapshotKmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.RdsDbSnapshotConfiguration
  ) extends zio.aws.accessanalyzer.model.RdsDbSnapshotConfiguration.ReadOnly {
    override val attributes: Optional[Map[
      RdsDbSnapshotAttributeName,
      zio.aws.accessanalyzer.model.RdsDbSnapshotAttributeValue.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.attributes())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.accessanalyzer.model.primitives.RdsDbSnapshotAttributeName(
              key
            ) -> zio.aws.accessanalyzer.model.RdsDbSnapshotAttributeValue
              .wrap(value)
          })
          .toMap
      )
    override val kmsKeyId: Optional[RdsDbSnapshotKmsKeyId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kmsKeyId())
        .map(value =>
          zio.aws.accessanalyzer.model.primitives.RdsDbSnapshotKmsKeyId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.RdsDbSnapshotConfiguration
  ): zio.aws.accessanalyzer.model.RdsDbSnapshotConfiguration.ReadOnly =
    new Wrapper(impl)
}
