package zio.aws.accessanalyzer.model
import scala.jdk.CollectionConverters.*
sealed trait KmsGrantOperation {
  def unwrap
      : software.amazon.awssdk.services.accessanalyzer.model.KmsGrantOperation
}
object KmsGrantOperation {
  def wrap(
      value: software.amazon.awssdk.services.accessanalyzer.model.KmsGrantOperation
  ): zio.aws.accessanalyzer.model.KmsGrantOperation = value match {
    case software.amazon.awssdk.services.accessanalyzer.model.KmsGrantOperation.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.accessanalyzer.model.KmsGrantOperation.CREATE_GRANT =>
      val r = CreateGrant
      r
    case software.amazon.awssdk.services.accessanalyzer.model.KmsGrantOperation.DECRYPT =>
      val r = Decrypt
      r
    case software.amazon.awssdk.services.accessanalyzer.model.KmsGrantOperation.DESCRIBE_KEY =>
      val r = DescribeKey
      r
    case software.amazon.awssdk.services.accessanalyzer.model.KmsGrantOperation.ENCRYPT =>
      val r = Encrypt
      r
    case software.amazon.awssdk.services.accessanalyzer.model.KmsGrantOperation.GENERATE_DATA_KEY =>
      val r = GenerateDataKey
      r
    case software.amazon.awssdk.services.accessanalyzer.model.KmsGrantOperation.GENERATE_DATA_KEY_PAIR =>
      val r = GenerateDataKeyPair
      r
    case software.amazon.awssdk.services.accessanalyzer.model.KmsGrantOperation.GENERATE_DATA_KEY_PAIR_WITHOUT_PLAINTEXT =>
      val r = GenerateDataKeyPairWithoutPlaintext
      r
    case software.amazon.awssdk.services.accessanalyzer.model.KmsGrantOperation.GENERATE_DATA_KEY_WITHOUT_PLAINTEXT =>
      val r = GenerateDataKeyWithoutPlaintext
      r
    case software.amazon.awssdk.services.accessanalyzer.model.KmsGrantOperation.GET_PUBLIC_KEY =>
      val r = GetPublicKey
      r
    case software.amazon.awssdk.services.accessanalyzer.model.KmsGrantOperation.RE_ENCRYPT_FROM =>
      val r = ReEncryptFrom
      r
    case software.amazon.awssdk.services.accessanalyzer.model.KmsGrantOperation.RE_ENCRYPT_TO =>
      val r = ReEncryptTo
      r
    case software.amazon.awssdk.services.accessanalyzer.model.KmsGrantOperation.RETIRE_GRANT =>
      val r = RetireGrant
      r
    case software.amazon.awssdk.services.accessanalyzer.model.KmsGrantOperation.SIGN =>
      val r = Sign
      r
    case software.amazon.awssdk.services.accessanalyzer.model.KmsGrantOperation.VERIFY =>
      val r = Verify
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.accessanalyzer.model.KmsGrantOperation {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.KmsGrantOperation =
      software.amazon.awssdk.services.accessanalyzer.model.KmsGrantOperation.UNKNOWN_TO_SDK_VERSION
  }
  case object CreateGrant
      extends zio.aws.accessanalyzer.model.KmsGrantOperation {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.KmsGrantOperation =
      software.amazon.awssdk.services.accessanalyzer.model.KmsGrantOperation.CREATE_GRANT
  }
  case object Decrypt extends zio.aws.accessanalyzer.model.KmsGrantOperation {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.KmsGrantOperation =
      software.amazon.awssdk.services.accessanalyzer.model.KmsGrantOperation.DECRYPT
  }
  case object DescribeKey
      extends zio.aws.accessanalyzer.model.KmsGrantOperation {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.KmsGrantOperation =
      software.amazon.awssdk.services.accessanalyzer.model.KmsGrantOperation.DESCRIBE_KEY
  }
  case object Encrypt extends zio.aws.accessanalyzer.model.KmsGrantOperation {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.KmsGrantOperation =
      software.amazon.awssdk.services.accessanalyzer.model.KmsGrantOperation.ENCRYPT
  }
  case object GenerateDataKey
      extends zio.aws.accessanalyzer.model.KmsGrantOperation {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.KmsGrantOperation =
      software.amazon.awssdk.services.accessanalyzer.model.KmsGrantOperation.GENERATE_DATA_KEY
  }
  case object GenerateDataKeyPair
      extends zio.aws.accessanalyzer.model.KmsGrantOperation {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.KmsGrantOperation =
      software.amazon.awssdk.services.accessanalyzer.model.KmsGrantOperation.GENERATE_DATA_KEY_PAIR
  }
  case object GenerateDataKeyPairWithoutPlaintext
      extends zio.aws.accessanalyzer.model.KmsGrantOperation {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.KmsGrantOperation =
      software.amazon.awssdk.services.accessanalyzer.model.KmsGrantOperation.GENERATE_DATA_KEY_PAIR_WITHOUT_PLAINTEXT
  }
  case object GenerateDataKeyWithoutPlaintext
      extends zio.aws.accessanalyzer.model.KmsGrantOperation {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.KmsGrantOperation =
      software.amazon.awssdk.services.accessanalyzer.model.KmsGrantOperation.GENERATE_DATA_KEY_WITHOUT_PLAINTEXT
  }
  case object GetPublicKey
      extends zio.aws.accessanalyzer.model.KmsGrantOperation {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.KmsGrantOperation =
      software.amazon.awssdk.services.accessanalyzer.model.KmsGrantOperation.GET_PUBLIC_KEY
  }
  case object ReEncryptFrom
      extends zio.aws.accessanalyzer.model.KmsGrantOperation {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.KmsGrantOperation =
      software.amazon.awssdk.services.accessanalyzer.model.KmsGrantOperation.RE_ENCRYPT_FROM
  }
  case object ReEncryptTo
      extends zio.aws.accessanalyzer.model.KmsGrantOperation {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.KmsGrantOperation =
      software.amazon.awssdk.services.accessanalyzer.model.KmsGrantOperation.RE_ENCRYPT_TO
  }
  case object RetireGrant
      extends zio.aws.accessanalyzer.model.KmsGrantOperation {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.KmsGrantOperation =
      software.amazon.awssdk.services.accessanalyzer.model.KmsGrantOperation.RETIRE_GRANT
  }
  case object Sign extends zio.aws.accessanalyzer.model.KmsGrantOperation {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.KmsGrantOperation =
      software.amazon.awssdk.services.accessanalyzer.model.KmsGrantOperation.SIGN
  }
  case object Verify extends zio.aws.accessanalyzer.model.KmsGrantOperation {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.KmsGrantOperation =
      software.amazon.awssdk.services.accessanalyzer.model.KmsGrantOperation.VERIFY
  }
}
