package zio.aws.accessanalyzer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GeneratedPolicyResult(
    properties: zio.aws.accessanalyzer.model.GeneratedPolicyProperties,
    generatedPolicies: Optional[
      Iterable[zio.aws.accessanalyzer.model.GeneratedPolicy]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.GeneratedPolicyResult = {
    import GeneratedPolicyResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.GeneratedPolicyResult
      .builder()
      .properties(properties.buildAwsValue())
      .optionallyWith(
        generatedPolicies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.generatedPolicies)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.GeneratedPolicyResult.ReadOnly =
    zio.aws.accessanalyzer.model.GeneratedPolicyResult.wrap(buildAwsValue())
}
object GeneratedPolicyResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.GeneratedPolicyResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.GeneratedPolicyResult =
      zio.aws.accessanalyzer.model.GeneratedPolicyResult(
        properties.asEditable,
        generatedPolicies.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def properties
        : zio.aws.accessanalyzer.model.GeneratedPolicyProperties.ReadOnly
    def generatedPolicies
        : Optional[List[zio.aws.accessanalyzer.model.GeneratedPolicy.ReadOnly]]
    def getProperties: ZIO[
      Any,
      Nothing,
      zio.aws.accessanalyzer.model.GeneratedPolicyProperties.ReadOnly
    ] = ZIO.succeed(properties)
    def getGeneratedPolicies: ZIO[Any, AwsError, List[
      zio.aws.accessanalyzer.model.GeneratedPolicy.ReadOnly
    ]] = AwsError.unwrapOptionField("generatedPolicies", generatedPolicies)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.GeneratedPolicyResult
  ) extends zio.aws.accessanalyzer.model.GeneratedPolicyResult.ReadOnly {
    override val properties
        : zio.aws.accessanalyzer.model.GeneratedPolicyProperties.ReadOnly =
      zio.aws.accessanalyzer.model.GeneratedPolicyProperties
        .wrap(impl.properties())
    override val generatedPolicies: Optional[
      List[zio.aws.accessanalyzer.model.GeneratedPolicy.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.generatedPolicies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.accessanalyzer.model.GeneratedPolicy.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.GeneratedPolicyResult
  ): zio.aws.accessanalyzer.model.GeneratedPolicyResult.ReadOnly = new Wrapper(
    impl
  )
}
