package zio.aws.accessanalyzer.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.accessanalyzer.model.primitives.{
  Timestamp,
  FindingId,
  AccessPreviewFindingId
}
import scala.jdk.CollectionConverters.*
final case class AccessPreviewFinding(
    id: AccessPreviewFindingId,
    existingFindingId: Optional[FindingId] = Optional.Absent,
    existingFindingStatus: Optional[
      zio.aws.accessanalyzer.model.FindingStatus
    ] = Optional.Absent,
    principal: Optional[Map[String, String]] = Optional.Absent,
    action: Optional[Iterable[String]] = Optional.Absent,
    condition: Optional[Map[String, String]] = Optional.Absent,
    resource: Optional[String] = Optional.Absent,
    isPublic: Optional[Boolean] = Optional.Absent,
    resourceType: zio.aws.accessanalyzer.model.ResourceType,
    createdAt: Timestamp,
    changeType: zio.aws.accessanalyzer.model.FindingChangeType,
    status: zio.aws.accessanalyzer.model.FindingStatus,
    resourceOwnerAccount: String,
    error: Optional[String] = Optional.Absent,
    sources: Optional[Iterable[zio.aws.accessanalyzer.model.FindingSource]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.AccessPreviewFinding = {
    import AccessPreviewFinding.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.AccessPreviewFinding
      .builder()
      .id(AccessPreviewFindingId.unwrap(id): java.lang.String)
      .optionallyWith(
        existingFindingId.map(value =>
          FindingId.unwrap(value): java.lang.String
        )
      )(_.existingFindingId)
      .optionallyWith(existingFindingStatus.map(value => value.unwrap))(
        _.existingFindingStatus
      )
      .optionallyWith(
        principal.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.principal)
      .optionallyWith(
        action.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.action)
      .optionallyWith(
        condition.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.condition)
      .optionallyWith(resource.map(value => value: java.lang.String))(
        _.resource
      )
      .optionallyWith(isPublic.map(value => value: java.lang.Boolean))(
        _.isPublic
      )
      .resourceType(resourceType.unwrap)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .changeType(changeType.unwrap)
      .status(status.unwrap)
      .resourceOwnerAccount(resourceOwnerAccount: java.lang.String)
      .optionallyWith(error.map(value => value: java.lang.String))(_.error)
      .optionallyWith(
        sources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sources)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.AccessPreviewFinding.ReadOnly =
    zio.aws.accessanalyzer.model.AccessPreviewFinding.wrap(buildAwsValue())
}
object AccessPreviewFinding {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.AccessPreviewFinding
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.AccessPreviewFinding =
      zio.aws.accessanalyzer.model.AccessPreviewFinding(
        id,
        existingFindingId.map(value => value),
        existingFindingStatus.map(value => value),
        principal.map(value => value),
        action.map(value => value),
        condition.map(value => value),
        resource.map(value => value),
        isPublic.map(value => value),
        resourceType,
        createdAt,
        changeType,
        status,
        resourceOwnerAccount,
        error.map(value => value),
        sources.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def id: AccessPreviewFindingId
    def existingFindingId: Optional[FindingId]
    def existingFindingStatus
        : Optional[zio.aws.accessanalyzer.model.FindingStatus]
    def principal: Optional[Map[String, String]]
    def action: Optional[List[String]]
    def condition: Optional[Map[String, String]]
    def resource: Optional[String]
    def isPublic: Optional[Boolean]
    def resourceType: zio.aws.accessanalyzer.model.ResourceType
    def createdAt: Timestamp
    def changeType: zio.aws.accessanalyzer.model.FindingChangeType
    def status: zio.aws.accessanalyzer.model.FindingStatus
    def resourceOwnerAccount: String
    def error: Optional[String]
    def sources
        : Optional[List[zio.aws.accessanalyzer.model.FindingSource.ReadOnly]]
    def getId: ZIO[Any, Nothing, AccessPreviewFindingId] = ZIO.succeed(id)
    def getExistingFindingId: ZIO[Any, AwsError, FindingId] =
      AwsError.unwrapOptionField("existingFindingId", existingFindingId)
    def getExistingFindingStatus
        : ZIO[Any, AwsError, zio.aws.accessanalyzer.model.FindingStatus] =
      AwsError.unwrapOptionField("existingFindingStatus", existingFindingStatus)
    def getPrincipal: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("principal", principal)
    def getAction: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("action", action)
    def getCondition: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("condition", condition)
    def getResource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resource", resource)
    def getIsPublic: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isPublic", isPublic)
    def getResourceType
        : ZIO[Any, Nothing, zio.aws.accessanalyzer.model.ResourceType] =
      ZIO.succeed(resourceType)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getChangeType
        : ZIO[Any, Nothing, zio.aws.accessanalyzer.model.FindingChangeType] =
      ZIO.succeed(changeType)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.accessanalyzer.model.FindingStatus] =
      ZIO.succeed(status)
    def getResourceOwnerAccount: ZIO[Any, Nothing, String] =
      ZIO.succeed(resourceOwnerAccount)
    def getError: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("error", error)
    def getSources: ZIO[Any, AwsError, List[
      zio.aws.accessanalyzer.model.FindingSource.ReadOnly
    ]] = AwsError.unwrapOptionField("sources", sources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.AccessPreviewFinding
  ) extends zio.aws.accessanalyzer.model.AccessPreviewFinding.ReadOnly {
    override val id: AccessPreviewFindingId =
      zio.aws.accessanalyzer.model.primitives.AccessPreviewFindingId(impl.id())
    override val existingFindingId: Optional[FindingId] = zio.aws.core.internal
      .optionalFromNullable(impl.existingFindingId())
      .map(value => zio.aws.accessanalyzer.model.primitives.FindingId(value))
    override val existingFindingStatus
        : Optional[zio.aws.accessanalyzer.model.FindingStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.existingFindingStatus())
        .map(value => zio.aws.accessanalyzer.model.FindingStatus.wrap(value))
    override val principal: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.principal())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
    override val action: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.action())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val condition: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.condition())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
    override val resource: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resource())
      .map(value => value: String)
    override val isPublic: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isPublic())
      .map(value => value: Boolean)
    override val resourceType: zio.aws.accessanalyzer.model.ResourceType =
      zio.aws.accessanalyzer.model.ResourceType.wrap(impl.resourceType())
    override val createdAt: Timestamp =
      zio.aws.accessanalyzer.model.primitives.Timestamp(impl.createdAt())
    override val changeType: zio.aws.accessanalyzer.model.FindingChangeType =
      zio.aws.accessanalyzer.model.FindingChangeType.wrap(impl.changeType())
    override val status: zio.aws.accessanalyzer.model.FindingStatus =
      zio.aws.accessanalyzer.model.FindingStatus.wrap(impl.status())
    override val resourceOwnerAccount: String =
      impl.resourceOwnerAccount(): String
    override val error: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.error())
      .map(value => value: String)
    override val sources
        : Optional[List[zio.aws.accessanalyzer.model.FindingSource.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.accessanalyzer.model.FindingSource.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.AccessPreviewFinding
  ): zio.aws.accessanalyzer.model.AccessPreviewFinding.ReadOnly = new Wrapper(
    impl
  )
}
