package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.{
  ResourceArn,
  FindingId,
  AnalyzerArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateFindingsRequest(
    analyzerArn: AnalyzerArn,
    status: zio.aws.accessanalyzer.model.FindingStatusUpdate,
    ids: Optional[Iterable[FindingId]] = Optional.Absent,
    resourceArn: Optional[ResourceArn] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.UpdateFindingsRequest = {
    import UpdateFindingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.UpdateFindingsRequest
      .builder()
      .analyzerArn(AnalyzerArn.unwrap(analyzerArn): java.lang.String)
      .status(status.unwrap)
      .optionallyWith(
        ids.map(value =>
          value.map { item =>
            FindingId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ids)
      .optionallyWith(
        resourceArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.UpdateFindingsRequest.ReadOnly =
    zio.aws.accessanalyzer.model.UpdateFindingsRequest.wrap(buildAwsValue())
}
object UpdateFindingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.UpdateFindingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.UpdateFindingsRequest =
      zio.aws.accessanalyzer.model.UpdateFindingsRequest(
        analyzerArn,
        status,
        ids.map(value => value),
        resourceArn.map(value => value),
        clientToken.map(value => value)
      )
    def analyzerArn: AnalyzerArn
    def status: zio.aws.accessanalyzer.model.FindingStatusUpdate
    def ids: Optional[List[FindingId]]
    def resourceArn: Optional[ResourceArn]
    def clientToken: Optional[String]
    def getAnalyzerArn: ZIO[Any, Nothing, AnalyzerArn] =
      ZIO.succeed(analyzerArn)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.accessanalyzer.model.FindingStatusUpdate] =
      ZIO.succeed(status)
    def getIds: ZIO[Any, AwsError, List[FindingId]] =
      AwsError.unwrapOptionField("ids", ids)
    def getResourceArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.UpdateFindingsRequest
  ) extends zio.aws.accessanalyzer.model.UpdateFindingsRequest.ReadOnly {
    override val analyzerArn: AnalyzerArn =
      zio.aws.accessanalyzer.model.primitives.AnalyzerArn(impl.analyzerArn())
    override val status: zio.aws.accessanalyzer.model.FindingStatusUpdate =
      zio.aws.accessanalyzer.model.FindingStatusUpdate.wrap(impl.status())
    override val ids: Optional[List[FindingId]] = zio.aws.core.internal
      .optionalFromNullable(impl.ids())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.accessanalyzer.model.primitives.FindingId(item)
        }.toList
      )
    override val resourceArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArn())
      .map(value => zio.aws.accessanalyzer.model.primitives.ResourceArn(value))
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.UpdateFindingsRequest
  ): zio.aws.accessanalyzer.model.UpdateFindingsRequest.ReadOnly = new Wrapper(
    impl
  )
}
