package zio.aws.accessanalyzer.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetAnalyzerResponse(
    analyzer: zio.aws.accessanalyzer.model.AnalyzerSummary
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.GetAnalyzerResponse = {
    import GetAnalyzerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.GetAnalyzerResponse
      .builder()
      .analyzer(analyzer.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.GetAnalyzerResponse.ReadOnly =
    zio.aws.accessanalyzer.model.GetAnalyzerResponse.wrap(buildAwsValue())
}
object GetAnalyzerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.GetAnalyzerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.GetAnalyzerResponse =
      zio.aws.accessanalyzer.model.GetAnalyzerResponse(analyzer.asEditable)
    def analyzer: zio.aws.accessanalyzer.model.AnalyzerSummary.ReadOnly
    def getAnalyzer: ZIO[
      Any,
      Nothing,
      zio.aws.accessanalyzer.model.AnalyzerSummary.ReadOnly
    ] = ZIO.succeed(analyzer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.GetAnalyzerResponse
  ) extends zio.aws.accessanalyzer.model.GetAnalyzerResponse.ReadOnly {
    override val analyzer
        : zio.aws.accessanalyzer.model.AnalyzerSummary.ReadOnly =
      zio.aws.accessanalyzer.model.AnalyzerSummary.wrap(impl.analyzer())
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.GetAnalyzerResponse
  ): zio.aws.accessanalyzer.model.GetAnalyzerResponse.ReadOnly = new Wrapper(
    impl
  )
}
