package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class CloudTrailProperties(
    trailProperties: Iterable[zio.aws.accessanalyzer.model.TrailProperties],
    startTime: Timestamp,
    endTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.CloudTrailProperties = {
    import CloudTrailProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.CloudTrailProperties
      .builder()
      .trailProperties(trailProperties.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .startTime(Timestamp.unwrap(startTime): Instant)
      .endTime(Timestamp.unwrap(endTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.CloudTrailProperties.ReadOnly =
    zio.aws.accessanalyzer.model.CloudTrailProperties.wrap(buildAwsValue())
}
object CloudTrailProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.CloudTrailProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.CloudTrailProperties =
      zio.aws.accessanalyzer.model.CloudTrailProperties(
        trailProperties.map { item =>
          item.asEditable
        },
        startTime,
        endTime
      )
    def trailProperties
        : List[zio.aws.accessanalyzer.model.TrailProperties.ReadOnly]
    def startTime: Timestamp
    def endTime: Timestamp
    def getTrailProperties: ZIO[Any, Nothing, List[
      zio.aws.accessanalyzer.model.TrailProperties.ReadOnly
    ]] = ZIO.succeed(trailProperties)
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
    def getEndTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.CloudTrailProperties
  ) extends zio.aws.accessanalyzer.model.CloudTrailProperties.ReadOnly {
    override val trailProperties
        : List[zio.aws.accessanalyzer.model.TrailProperties.ReadOnly] = impl
      .trailProperties()
      .asScala
      .map { item =>
        zio.aws.accessanalyzer.model.TrailProperties.wrap(item)
      }
      .toList
    override val startTime: Timestamp =
      zio.aws.accessanalyzer.model.primitives.Timestamp(impl.startTime())
    override val endTime: Timestamp =
      zio.aws.accessanalyzer.model.primitives.Timestamp(impl.endTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.CloudTrailProperties
  ): zio.aws.accessanalyzer.model.CloudTrailProperties.ReadOnly = new Wrapper(
    impl
  )
}
