package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.{
  IssuingAccount,
  RetiringPrincipal,
  GranteePrincipal
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class KmsGrantConfiguration(
    operations: Iterable[zio.aws.accessanalyzer.model.KmsGrantOperation],
    granteePrincipal: GranteePrincipal,
    retiringPrincipal: Optional[RetiringPrincipal] = Optional.Absent,
    constraints: Optional[zio.aws.accessanalyzer.model.KmsGrantConstraints] =
      Optional.Absent,
    issuingAccount: IssuingAccount
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.KmsGrantConfiguration = {
    import KmsGrantConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.KmsGrantConfiguration
      .builder()
      .operationsWithStrings(operations.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .granteePrincipal(
        GranteePrincipal.unwrap(granteePrincipal): java.lang.String
      )
      .optionallyWith(
        retiringPrincipal.map(value =>
          RetiringPrincipal.unwrap(value): java.lang.String
        )
      )(_.retiringPrincipal)
      .optionallyWith(constraints.map(value => value.buildAwsValue()))(
        _.constraints
      )
      .issuingAccount(IssuingAccount.unwrap(issuingAccount): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.KmsGrantConfiguration.ReadOnly =
    zio.aws.accessanalyzer.model.KmsGrantConfiguration.wrap(buildAwsValue())
}
object KmsGrantConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.KmsGrantConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.KmsGrantConfiguration =
      zio.aws.accessanalyzer.model.KmsGrantConfiguration(
        operations,
        granteePrincipal,
        retiringPrincipal.map(value => value),
        constraints.map(value => value.asEditable),
        issuingAccount
      )
    def operations: List[zio.aws.accessanalyzer.model.KmsGrantOperation]
    def granteePrincipal: GranteePrincipal
    def retiringPrincipal: Optional[RetiringPrincipal]
    def constraints
        : Optional[zio.aws.accessanalyzer.model.KmsGrantConstraints.ReadOnly]
    def issuingAccount: IssuingAccount
    def getOperations: ZIO[Any, Nothing, List[
      zio.aws.accessanalyzer.model.KmsGrantOperation
    ]] = ZIO.succeed(operations)
    def getGranteePrincipal: ZIO[Any, Nothing, GranteePrincipal] =
      ZIO.succeed(granteePrincipal)
    def getRetiringPrincipal: ZIO[Any, AwsError, RetiringPrincipal] =
      AwsError.unwrapOptionField("retiringPrincipal", retiringPrincipal)
    def getConstraints: ZIO[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.KmsGrantConstraints.ReadOnly
    ] = AwsError.unwrapOptionField("constraints", constraints)
    def getIssuingAccount: ZIO[Any, Nothing, IssuingAccount] =
      ZIO.succeed(issuingAccount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.KmsGrantConfiguration
  ) extends zio.aws.accessanalyzer.model.KmsGrantConfiguration.ReadOnly {
    override val operations
        : List[zio.aws.accessanalyzer.model.KmsGrantOperation] = impl
      .operations()
      .asScala
      .map { item =>
        zio.aws.accessanalyzer.model.KmsGrantOperation.wrap(item)
      }
      .toList
    override val granteePrincipal: GranteePrincipal =
      zio.aws.accessanalyzer.model.primitives
        .GranteePrincipal(impl.granteePrincipal())
    override val retiringPrincipal: Optional[RetiringPrincipal] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retiringPrincipal())
        .map(value =>
          zio.aws.accessanalyzer.model.primitives.RetiringPrincipal(value)
        )
    override val constraints
        : Optional[zio.aws.accessanalyzer.model.KmsGrantConstraints.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.constraints())
        .map(value =>
          zio.aws.accessanalyzer.model.KmsGrantConstraints.wrap(value)
        )
    override val issuingAccount: IssuingAccount =
      zio.aws.accessanalyzer.model.primitives
        .IssuingAccount(impl.issuingAccount())
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.KmsGrantConfiguration
  ): zio.aws.accessanalyzer.model.KmsGrantConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
