package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.Name
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateArchiveRuleRequest(
    analyzerName: Name,
    ruleName: Name,
    filter: Map[String, zio.aws.accessanalyzer.model.Criterion],
    clientToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.CreateArchiveRuleRequest = {
    import CreateArchiveRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.CreateArchiveRuleRequest
      .builder()
      .analyzerName(Name.unwrap(analyzerName): java.lang.String)
      .ruleName(Name.unwrap(ruleName): java.lang.String)
      .filter(
        filter
          .map({ case (key, value) =>
            (key: java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.CreateArchiveRuleRequest.ReadOnly =
    zio.aws.accessanalyzer.model.CreateArchiveRuleRequest.wrap(buildAwsValue())
}
object CreateArchiveRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.CreateArchiveRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.CreateArchiveRuleRequest =
      zio.aws.accessanalyzer.model.CreateArchiveRuleRequest(
        analyzerName,
        ruleName,
        filter.map({ case (key, value) =>
          key -> value.asEditable
        }),
        clientToken.map(value => value)
      )
    def analyzerName: Name
    def ruleName: Name
    def filter: Map[String, zio.aws.accessanalyzer.model.Criterion.ReadOnly]
    def clientToken: Optional[String]
    def getAnalyzerName: ZIO[Any, Nothing, Name] = ZIO.succeed(analyzerName)
    def getRuleName: ZIO[Any, Nothing, Name] = ZIO.succeed(ruleName)
    def getFilter: ZIO[Any, Nothing, Map[
      String,
      zio.aws.accessanalyzer.model.Criterion.ReadOnly
    ]] = ZIO.succeed(filter)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.CreateArchiveRuleRequest
  ) extends zio.aws.accessanalyzer.model.CreateArchiveRuleRequest.ReadOnly {
    override val analyzerName: Name =
      zio.aws.accessanalyzer.model.primitives.Name(impl.analyzerName())
    override val ruleName: Name =
      zio.aws.accessanalyzer.model.primitives.Name(impl.ruleName())
    override val filter
        : Map[String, zio.aws.accessanalyzer.model.Criterion.ReadOnly] = impl
      .filter()
      .asScala
      .map({ case (key, value) =>
        (key: String) -> zio.aws.accessanalyzer.model.Criterion.wrap(value)
      })
      .toMap
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.CreateArchiveRuleRequest
  ): zio.aws.accessanalyzer.model.CreateArchiveRuleRequest.ReadOnly =
    new Wrapper(impl)
}
