package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.SqsQueuePolicy
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SqsQueueConfiguration(
    queuePolicy: Optional[SqsQueuePolicy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.SqsQueueConfiguration = {
    import SqsQueueConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.SqsQueueConfiguration
      .builder()
      .optionallyWith(
        queuePolicy.map(value => SqsQueuePolicy.unwrap(value): java.lang.String)
      )(_.queuePolicy)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.SqsQueueConfiguration.ReadOnly =
    zio.aws.accessanalyzer.model.SqsQueueConfiguration.wrap(buildAwsValue())
}
object SqsQueueConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.SqsQueueConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.SqsQueueConfiguration =
      zio.aws.accessanalyzer.model
        .SqsQueueConfiguration(queuePolicy.map(value => value))
    def queuePolicy: Optional[SqsQueuePolicy]
    def getQueuePolicy: ZIO[Any, AwsError, SqsQueuePolicy] =
      AwsError.unwrapOptionField("queuePolicy", queuePolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.SqsQueueConfiguration
  ) extends zio.aws.accessanalyzer.model.SqsQueueConfiguration.ReadOnly {
    override val queuePolicy: Optional[SqsQueuePolicy] = zio.aws.core.internal
      .optionalFromNullable(impl.queuePolicy())
      .map(value =>
        zio.aws.accessanalyzer.model.primitives.SqsQueuePolicy(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.SqsQueueConfiguration
  ): zio.aws.accessanalyzer.model.SqsQueueConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
