package zio.aws.accessanalyzer.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.accessanalyzer.model.primitives.{Timestamp, FindingId}
import scala.jdk.CollectionConverters.*
final case class Finding(
    id: FindingId,
    principal: Optional[Map[String, String]] = Optional.Absent,
    action: Optional[Iterable[String]] = Optional.Absent,
    resource: Optional[String] = Optional.Absent,
    isPublic: Optional[Boolean] = Optional.Absent,
    resourceType: zio.aws.accessanalyzer.model.ResourceType,
    condition: Map[String, String],
    createdAt: Timestamp,
    analyzedAt: Timestamp,
    updatedAt: Timestamp,
    status: zio.aws.accessanalyzer.model.FindingStatus,
    resourceOwnerAccount: String,
    error: Optional[String] = Optional.Absent,
    sources: Optional[Iterable[zio.aws.accessanalyzer.model.FindingSource]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.Finding = {
    import Finding.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.Finding
      .builder()
      .id(FindingId.unwrap(id): java.lang.String)
      .optionallyWith(
        principal.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.principal)
      .optionallyWith(
        action.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.action)
      .optionallyWith(resource.map(value => value: java.lang.String))(
        _.resource
      )
      .optionallyWith(isPublic.map(value => value: java.lang.Boolean))(
        _.isPublic
      )
      .resourceType(resourceType.unwrap)
      .condition(
        condition
          .map({ case (key, value) =>
            (key: java.lang.String) -> (value: java.lang.String)
          })
          .asJava
      )
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .analyzedAt(Timestamp.unwrap(analyzedAt): Instant)
      .updatedAt(Timestamp.unwrap(updatedAt): Instant)
      .status(status.unwrap)
      .resourceOwnerAccount(resourceOwnerAccount: java.lang.String)
      .optionallyWith(error.map(value => value: java.lang.String))(_.error)
      .optionallyWith(
        sources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sources)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.Finding.ReadOnly =
    zio.aws.accessanalyzer.model.Finding.wrap(buildAwsValue())
}
object Finding {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.Finding
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.Finding =
      zio.aws.accessanalyzer.model.Finding(
        id,
        principal.map(value => value),
        action.map(value => value),
        resource.map(value => value),
        isPublic.map(value => value),
        resourceType,
        condition,
        createdAt,
        analyzedAt,
        updatedAt,
        status,
        resourceOwnerAccount,
        error.map(value => value),
        sources.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def id: FindingId
    def principal: Optional[Map[String, String]]
    def action: Optional[List[String]]
    def resource: Optional[String]
    def isPublic: Optional[Boolean]
    def resourceType: zio.aws.accessanalyzer.model.ResourceType
    def condition: Map[String, String]
    def createdAt: Timestamp
    def analyzedAt: Timestamp
    def updatedAt: Timestamp
    def status: zio.aws.accessanalyzer.model.FindingStatus
    def resourceOwnerAccount: String
    def error: Optional[String]
    def sources
        : Optional[List[zio.aws.accessanalyzer.model.FindingSource.ReadOnly]]
    def getId: ZIO[Any, Nothing, FindingId] = ZIO.succeed(id)
    def getPrincipal: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("principal", principal)
    def getAction: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("action", action)
    def getResource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resource", resource)
    def getIsPublic: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isPublic", isPublic)
    def getResourceType
        : ZIO[Any, Nothing, zio.aws.accessanalyzer.model.ResourceType] =
      ZIO.succeed(resourceType)
    def getCondition: ZIO[Any, Nothing, Map[String, String]] =
      ZIO.succeed(condition)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getAnalyzedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(analyzedAt)
    def getUpdatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updatedAt)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.accessanalyzer.model.FindingStatus] =
      ZIO.succeed(status)
    def getResourceOwnerAccount: ZIO[Any, Nothing, String] =
      ZIO.succeed(resourceOwnerAccount)
    def getError: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("error", error)
    def getSources: ZIO[Any, AwsError, List[
      zio.aws.accessanalyzer.model.FindingSource.ReadOnly
    ]] = AwsError.unwrapOptionField("sources", sources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.Finding
  ) extends zio.aws.accessanalyzer.model.Finding.ReadOnly {
    override val id: FindingId =
      zio.aws.accessanalyzer.model.primitives.FindingId(impl.id())
    override val principal: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.principal())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
    override val action: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.action())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val resource: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resource())
      .map(value => value: String)
    override val isPublic: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isPublic())
      .map(value => value: Boolean)
    override val resourceType: zio.aws.accessanalyzer.model.ResourceType =
      zio.aws.accessanalyzer.model.ResourceType.wrap(impl.resourceType())
    override val condition: Map[String, String] = impl
      .condition()
      .asScala
      .map({ case (key, value) =>
        (key: String) -> (value: String)
      })
      .toMap
    override val createdAt: Timestamp =
      zio.aws.accessanalyzer.model.primitives.Timestamp(impl.createdAt())
    override val analyzedAt: Timestamp =
      zio.aws.accessanalyzer.model.primitives.Timestamp(impl.analyzedAt())
    override val updatedAt: Timestamp =
      zio.aws.accessanalyzer.model.primitives.Timestamp(impl.updatedAt())
    override val status: zio.aws.accessanalyzer.model.FindingStatus =
      zio.aws.accessanalyzer.model.FindingStatus.wrap(impl.status())
    override val resourceOwnerAccount: String =
      impl.resourceOwnerAccount(): String
    override val error: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.error())
      .map(value => value: String)
    override val sources
        : Optional[List[zio.aws.accessanalyzer.model.FindingSource.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.accessanalyzer.model.FindingSource.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.Finding
  ): zio.aws.accessanalyzer.model.Finding.ReadOnly = new Wrapper(impl)
}
