package zio.aws.accessanalyzer.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.accessanalyzer.model.primitives.{
  Timestamp,
  ConfigurationsMapKey,
  AnalyzerArn,
  AccessPreviewId
}
import scala.jdk.CollectionConverters.*
final case class AccessPreview(
    id: AccessPreviewId,
    analyzerArn: AnalyzerArn,
    configurations: Map[
      ConfigurationsMapKey,
      zio.aws.accessanalyzer.model.Configuration
    ],
    createdAt: Timestamp,
    status: zio.aws.accessanalyzer.model.AccessPreviewStatus,
    statusReason: Optional[
      zio.aws.accessanalyzer.model.AccessPreviewStatusReason
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.AccessPreview = {
    import AccessPreview.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.AccessPreview
      .builder()
      .id(AccessPreviewId.unwrap(id): java.lang.String)
      .analyzerArn(AnalyzerArn.unwrap(analyzerArn): java.lang.String)
      .configurations(
        configurations
          .map({ case (key, value) =>
            (ConfigurationsMapKey.unwrap(key): java.lang.String) -> value
              .buildAwsValue()
          })
          .asJava
      )
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .status(status.unwrap)
      .optionallyWith(statusReason.map(value => value.buildAwsValue()))(
        _.statusReason
      )
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.AccessPreview.ReadOnly =
    zio.aws.accessanalyzer.model.AccessPreview.wrap(buildAwsValue())
}
object AccessPreview {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.AccessPreview
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.AccessPreview =
      zio.aws.accessanalyzer.model.AccessPreview(
        id,
        analyzerArn,
        configurations.map({ case (key, value) =>
          key -> value.asEditable
        }),
        createdAt,
        status,
        statusReason.map(value => value.asEditable)
      )
    def id: AccessPreviewId
    def analyzerArn: AnalyzerArn
    def configurations: Map[
      ConfigurationsMapKey,
      zio.aws.accessanalyzer.model.Configuration.ReadOnly
    ]
    def createdAt: Timestamp
    def status: zio.aws.accessanalyzer.model.AccessPreviewStatus
    def statusReason: Optional[
      zio.aws.accessanalyzer.model.AccessPreviewStatusReason.ReadOnly
    ]
    def getId: ZIO[Any, Nothing, AccessPreviewId] = ZIO.succeed(id)
    def getAnalyzerArn: ZIO[Any, Nothing, AnalyzerArn] =
      ZIO.succeed(analyzerArn)
    def getConfigurations: ZIO[Any, Nothing, Map[
      ConfigurationsMapKey,
      zio.aws.accessanalyzer.model.Configuration.ReadOnly
    ]] = ZIO.succeed(configurations)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.accessanalyzer.model.AccessPreviewStatus] =
      ZIO.succeed(status)
    def getStatusReason: ZIO[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.AccessPreviewStatusReason.ReadOnly
    ] = AwsError.unwrapOptionField("statusReason", statusReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.AccessPreview
  ) extends zio.aws.accessanalyzer.model.AccessPreview.ReadOnly {
    override val id: AccessPreviewId =
      zio.aws.accessanalyzer.model.primitives.AccessPreviewId(impl.id())
    override val analyzerArn: AnalyzerArn =
      zio.aws.accessanalyzer.model.primitives.AnalyzerArn(impl.analyzerArn())
    override val configurations: Map[
      ConfigurationsMapKey,
      zio.aws.accessanalyzer.model.Configuration.ReadOnly
    ] = impl
      .configurations()
      .asScala
      .map({ case (key, value) =>
        zio.aws.accessanalyzer.model.primitives.ConfigurationsMapKey(
          key
        ) -> zio.aws.accessanalyzer.model.Configuration.wrap(value)
      })
      .toMap
    override val createdAt: Timestamp =
      zio.aws.accessanalyzer.model.primitives.Timestamp(impl.createdAt())
    override val status: zio.aws.accessanalyzer.model.AccessPreviewStatus =
      zio.aws.accessanalyzer.model.AccessPreviewStatus.wrap(impl.status())
    override val statusReason: Optional[
      zio.aws.accessanalyzer.model.AccessPreviewStatusReason.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.statusReason())
      .map(value =>
        zio.aws.accessanalyzer.model.AccessPreviewStatusReason.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.AccessPreview
  ): zio.aws.accessanalyzer.model.AccessPreview.ReadOnly = new Wrapper(impl)
}
