package zio.aws.accessanalyzer.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.accessanalyzer.model.primitives.{
  PrincipalArn,
  Token,
  ListPolicyGenerationsRequestMaxResultsInteger
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListPolicyGenerationsRequest(
    maxResults: Optional[ListPolicyGenerationsRequestMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent,
    principalArn: Optional[PrincipalArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.ListPolicyGenerationsRequest = {
    import ListPolicyGenerationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.ListPolicyGenerationsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          ListPolicyGenerationsRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        principalArn.map(value => PrincipalArn.unwrap(value): java.lang.String)
      )(_.principalArn)
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.ListPolicyGenerationsRequest.ReadOnly =
    zio.aws.accessanalyzer.model.ListPolicyGenerationsRequest
      .wrap(buildAwsValue())
}
object ListPolicyGenerationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.ListPolicyGenerationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.ListPolicyGenerationsRequest =
      zio.aws.accessanalyzer.model.ListPolicyGenerationsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        principalArn.map(value => value)
      )
    def maxResults: Optional[ListPolicyGenerationsRequestMaxResultsInteger]
    def nextToken: Optional[Token]
    def principalArn: Optional[PrincipalArn]
    def getMaxResults
        : ZIO[Any, AwsError, ListPolicyGenerationsRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPrincipalArn: ZIO[Any, AwsError, PrincipalArn] =
      AwsError.unwrapOptionField("principalArn", principalArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ListPolicyGenerationsRequest
  ) extends zio.aws.accessanalyzer.model.ListPolicyGenerationsRequest.ReadOnly {
    override val maxResults
        : Optional[ListPolicyGenerationsRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.accessanalyzer.model.primitives
            .ListPolicyGenerationsRequestMaxResultsInteger(value)
        )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.accessanalyzer.model.primitives.Token(value))
    override val principalArn: Optional[PrincipalArn] = zio.aws.core.internal
      .optionalFromNullable(impl.principalArn())
      .map(value => zio.aws.accessanalyzer.model.primitives.PrincipalArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ListPolicyGenerationsRequest
  ): zio.aws.accessanalyzer.model.ListPolicyGenerationsRequest.ReadOnly =
    new Wrapper(impl)
}
