package zio.aws.accessanalyzer.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.accessanalyzer.model.primitives.{PrincipalArn, JobId, Timestamp}
import scala.jdk.CollectionConverters.*
final case class PolicyGeneration(
    completedOn: Optional[Timestamp] = Optional.Absent,
    jobId: JobId,
    principalArn: PrincipalArn,
    startedOn: Timestamp,
    status: zio.aws.accessanalyzer.model.JobStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.PolicyGeneration = {
    import PolicyGeneration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.PolicyGeneration
      .builder()
      .optionallyWith(
        completedOn.map(value => Timestamp.unwrap(value): Instant)
      )(_.completedOn)
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .principalArn(PrincipalArn.unwrap(principalArn): java.lang.String)
      .startedOn(Timestamp.unwrap(startedOn): Instant)
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.PolicyGeneration.ReadOnly =
    zio.aws.accessanalyzer.model.PolicyGeneration.wrap(buildAwsValue())
}
object PolicyGeneration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.PolicyGeneration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.PolicyGeneration =
      zio.aws.accessanalyzer.model.PolicyGeneration(
        completedOn.map(value => value),
        jobId,
        principalArn,
        startedOn,
        status
      )
    def completedOn: Optional[Timestamp]
    def jobId: JobId
    def principalArn: PrincipalArn
    def startedOn: Timestamp
    def status: zio.aws.accessanalyzer.model.JobStatus
    def getCompletedOn: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("completedOn", completedOn)
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getPrincipalArn: ZIO[Any, Nothing, PrincipalArn] =
      ZIO.succeed(principalArn)
    def getStartedOn: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startedOn)
    def getStatus: ZIO[Any, Nothing, zio.aws.accessanalyzer.model.JobStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.PolicyGeneration
  ) extends zio.aws.accessanalyzer.model.PolicyGeneration.ReadOnly {
    override val completedOn: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.completedOn())
      .map(value => zio.aws.accessanalyzer.model.primitives.Timestamp(value))
    override val jobId: JobId =
      zio.aws.accessanalyzer.model.primitives.JobId(impl.jobId())
    override val principalArn: PrincipalArn =
      zio.aws.accessanalyzer.model.primitives.PrincipalArn(impl.principalArn())
    override val startedOn: Timestamp =
      zio.aws.accessanalyzer.model.primitives.Timestamp(impl.startedOn())
    override val status: zio.aws.accessanalyzer.model.JobStatus =
      zio.aws.accessanalyzer.model.JobStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.PolicyGeneration
  ): zio.aws.accessanalyzer.model.PolicyGeneration.ReadOnly = new Wrapper(impl)
}
