package zio.aws.accessanalyzer.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.accessanalyzer.model.primitives.{FindingId, Timestamp}
import scala.jdk.CollectionConverters.*
final case class FindingSummary(
    action: Optional[Iterable[String]] = Optional.Absent,
    analyzedAt: Timestamp,
    condition: Map[String, String],
    createdAt: Timestamp,
    error: Optional[String] = Optional.Absent,
    id: FindingId,
    isPublic: Optional[Boolean] = Optional.Absent,
    principal: Optional[Map[String, String]] = Optional.Absent,
    resource: Optional[String] = Optional.Absent,
    resourceOwnerAccount: String,
    resourceType: zio.aws.accessanalyzer.model.ResourceType,
    sources: Optional[Iterable[zio.aws.accessanalyzer.model.FindingSource]] =
      Optional.Absent,
    status: zio.aws.accessanalyzer.model.FindingStatus,
    updatedAt: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.FindingSummary = {
    import FindingSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.FindingSummary
      .builder()
      .optionallyWith(
        action.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.action)
      .analyzedAt(Timestamp.unwrap(analyzedAt): Instant)
      .condition(
        condition
          .map({ case (key, value) =>
            (key: java.lang.String) -> (value: java.lang.String)
          })
          .asJava
      )
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .optionallyWith(error.map(value => value: java.lang.String))(_.error)
      .id(FindingId.unwrap(id): java.lang.String)
      .optionallyWith(isPublic.map(value => value: java.lang.Boolean))(
        _.isPublic
      )
      .optionallyWith(
        principal.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.principal)
      .optionallyWith(resource.map(value => value: java.lang.String))(
        _.resource
      )
      .resourceOwnerAccount(resourceOwnerAccount: java.lang.String)
      .resourceType(resourceType.unwrap)
      .optionallyWith(
        sources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sources)
      .status(status.unwrap)
      .updatedAt(Timestamp.unwrap(updatedAt): Instant)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.FindingSummary.ReadOnly =
    zio.aws.accessanalyzer.model.FindingSummary.wrap(buildAwsValue())
}
object FindingSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.FindingSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.FindingSummary =
      zio.aws.accessanalyzer.model.FindingSummary(
        action.map(value => value),
        analyzedAt,
        condition,
        createdAt,
        error.map(value => value),
        id,
        isPublic.map(value => value),
        principal.map(value => value),
        resource.map(value => value),
        resourceOwnerAccount,
        resourceType,
        sources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        status,
        updatedAt
      )
    def action: Optional[List[String]]
    def analyzedAt: Timestamp
    def condition: Map[String, String]
    def createdAt: Timestamp
    def error: Optional[String]
    def id: FindingId
    def isPublic: Optional[Boolean]
    def principal: Optional[Map[String, String]]
    def resource: Optional[String]
    def resourceOwnerAccount: String
    def resourceType: zio.aws.accessanalyzer.model.ResourceType
    def sources
        : Optional[List[zio.aws.accessanalyzer.model.FindingSource.ReadOnly]]
    def status: zio.aws.accessanalyzer.model.FindingStatus
    def updatedAt: Timestamp
    def getAction: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("action", action)
    def getAnalyzedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(analyzedAt)
    def getCondition: ZIO[Any, Nothing, Map[String, String]] =
      ZIO.succeed(condition)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getError: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("error", error)
    def getId: ZIO[Any, Nothing, FindingId] = ZIO.succeed(id)
    def getIsPublic: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isPublic", isPublic)
    def getPrincipal: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("principal", principal)
    def getResource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resource", resource)
    def getResourceOwnerAccount: ZIO[Any, Nothing, String] =
      ZIO.succeed(resourceOwnerAccount)
    def getResourceType
        : ZIO[Any, Nothing, zio.aws.accessanalyzer.model.ResourceType] =
      ZIO.succeed(resourceType)
    def getSources: ZIO[Any, AwsError, List[
      zio.aws.accessanalyzer.model.FindingSource.ReadOnly
    ]] = AwsError.unwrapOptionField("sources", sources)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.accessanalyzer.model.FindingStatus] =
      ZIO.succeed(status)
    def getUpdatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.FindingSummary
  ) extends zio.aws.accessanalyzer.model.FindingSummary.ReadOnly {
    override val action: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.action())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val analyzedAt: Timestamp =
      zio.aws.accessanalyzer.model.primitives.Timestamp(impl.analyzedAt())
    override val condition: Map[String, String] = impl
      .condition()
      .asScala
      .map({ case (key, value) =>
        (key: String) -> (value: String)
      })
      .toMap
    override val createdAt: Timestamp =
      zio.aws.accessanalyzer.model.primitives.Timestamp(impl.createdAt())
    override val error: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.error())
      .map(value => value: String)
    override val id: FindingId =
      zio.aws.accessanalyzer.model.primitives.FindingId(impl.id())
    override val isPublic: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isPublic())
      .map(value => value: Boolean)
    override val principal: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.principal())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
    override val resource: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resource())
      .map(value => value: String)
    override val resourceOwnerAccount: String =
      impl.resourceOwnerAccount(): String
    override val resourceType: zio.aws.accessanalyzer.model.ResourceType =
      zio.aws.accessanalyzer.model.ResourceType.wrap(impl.resourceType())
    override val sources
        : Optional[List[zio.aws.accessanalyzer.model.FindingSource.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.accessanalyzer.model.FindingSource.wrap(item)
          }.toList
        )
    override val status: zio.aws.accessanalyzer.model.FindingStatus =
      zio.aws.accessanalyzer.model.FindingStatus.wrap(impl.status())
    override val updatedAt: Timestamp =
      zio.aws.accessanalyzer.model.primitives.Timestamp(impl.updatedAt())
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.FindingSummary
  ): zio.aws.accessanalyzer.model.FindingSummary.ReadOnly = new Wrapper(impl)
}
