package zio.aws.accessanalyzer.model
import scala.jdk.CollectionConverters.*
sealed trait AnalyzerStatus {
  def unwrap
      : software.amazon.awssdk.services.accessanalyzer.model.AnalyzerStatus
}
object AnalyzerStatus {
  def wrap(
      value: software.amazon.awssdk.services.accessanalyzer.model.AnalyzerStatus
  ): zio.aws.accessanalyzer.model.AnalyzerStatus = value match {
    case software.amazon.awssdk.services.accessanalyzer.model.AnalyzerStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.accessanalyzer.model.AnalyzerStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.accessanalyzer.model.AnalyzerStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.accessanalyzer.model.AnalyzerStatus.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.accessanalyzer.model.AnalyzerStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.accessanalyzer.model.AnalyzerStatus {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.AnalyzerStatus =
      software.amazon.awssdk.services.accessanalyzer.model.AnalyzerStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.accessanalyzer.model.AnalyzerStatus {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.AnalyzerStatus =
      software.amazon.awssdk.services.accessanalyzer.model.AnalyzerStatus.ACTIVE
  }
  case object CREATING extends zio.aws.accessanalyzer.model.AnalyzerStatus {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.AnalyzerStatus =
      software.amazon.awssdk.services.accessanalyzer.model.AnalyzerStatus.CREATING
  }
  case object DISABLED extends zio.aws.accessanalyzer.model.AnalyzerStatus {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.AnalyzerStatus =
      software.amazon.awssdk.services.accessanalyzer.model.AnalyzerStatus.DISABLED
  }
  case object FAILED extends zio.aws.accessanalyzer.model.AnalyzerStatus {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.AnalyzerStatus =
      software.amazon.awssdk.services.accessanalyzer.model.AnalyzerStatus.FAILED
  }
}
