package zio.aws.accessanalyzer.model
import scala.jdk.CollectionConverters.*
sealed trait ValidatePolicyResourceType {
  def unwrap: software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyResourceType
}
object ValidatePolicyResourceType {
  def wrap(
      value: software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyResourceType
  ): zio.aws.accessanalyzer.model.ValidatePolicyResourceType = value match {
    case software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyResourceType.AWS_S3_BUCKET =>
      val r = `AWS::S3::Bucket`
      r
    case software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyResourceType.AWS_S3_ACCESS_POINT =>
      val r = `AWS::S3::AccessPoint`
      r
    case software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyResourceType.AWS_S3_MULTI_REGION_ACCESS_POINT =>
      val r = `AWS::S3::MultiRegionAccessPoint`
      r
    case software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyResourceType.AWS_S3_OBJECT_LAMBDA_ACCESS_POINT =>
      val r = `AWS::S3ObjectLambda::AccessPoint`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.accessanalyzer.model.ValidatePolicyResourceType {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyResourceType =
      software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object `AWS::S3::Bucket`
      extends zio.aws.accessanalyzer.model.ValidatePolicyResourceType {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyResourceType =
      software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyResourceType.AWS_S3_BUCKET
  }
  case object `AWS::S3::AccessPoint`
      extends zio.aws.accessanalyzer.model.ValidatePolicyResourceType {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyResourceType =
      software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyResourceType.AWS_S3_ACCESS_POINT
  }
  case object `AWS::S3::MultiRegionAccessPoint`
      extends zio.aws.accessanalyzer.model.ValidatePolicyResourceType {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyResourceType =
      software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyResourceType.AWS_S3_MULTI_REGION_ACCESS_POINT
  }
  case object `AWS::S3ObjectLambda::AccessPoint`
      extends zio.aws.accessanalyzer.model.ValidatePolicyResourceType {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyResourceType =
      software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyResourceType.AWS_S3_OBJECT_LAMBDA_ACCESS_POINT
  }
}
