package zio.aws.accessanalyzer.model
import scala.jdk.CollectionConverters.*
sealed trait PolicyType {
  def unwrap: software.amazon.awssdk.services.accessanalyzer.model.PolicyType
}
object PolicyType {
  def wrap(
      value: software.amazon.awssdk.services.accessanalyzer.model.PolicyType
  ): zio.aws.accessanalyzer.model.PolicyType = value match {
    case software.amazon.awssdk.services.accessanalyzer.model.PolicyType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.accessanalyzer.model.PolicyType.IDENTITY_POLICY =>
      val r = IDENTITY_POLICY
      r
    case software.amazon.awssdk.services.accessanalyzer.model.PolicyType.RESOURCE_POLICY =>
      val r = RESOURCE_POLICY
      r
    case software.amazon.awssdk.services.accessanalyzer.model.PolicyType.SERVICE_CONTROL_POLICY =>
      val r = SERVICE_CONTROL_POLICY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.accessanalyzer.model.PolicyType {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.PolicyType =
      software.amazon.awssdk.services.accessanalyzer.model.PolicyType.UNKNOWN_TO_SDK_VERSION
  }
  case object IDENTITY_POLICY extends zio.aws.accessanalyzer.model.PolicyType {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.PolicyType =
      software.amazon.awssdk.services.accessanalyzer.model.PolicyType.IDENTITY_POLICY
  }
  case object RESOURCE_POLICY extends zio.aws.accessanalyzer.model.PolicyType {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.PolicyType =
      software.amazon.awssdk.services.accessanalyzer.model.PolicyType.RESOURCE_POLICY
  }
  case object SERVICE_CONTROL_POLICY
      extends zio.aws.accessanalyzer.model.PolicyType {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.PolicyType =
      software.amazon.awssdk.services.accessanalyzer.model.PolicyType.SERVICE_CONTROL_POLICY
  }
}
