package zio.aws.accessanalyzer.model
import scala.jdk.CollectionConverters.*
sealed trait JobStatus {
  def unwrap: software.amazon.awssdk.services.accessanalyzer.model.JobStatus
}
object JobStatus {
  def wrap(
      value: software.amazon.awssdk.services.accessanalyzer.model.JobStatus
  ): zio.aws.accessanalyzer.model.JobStatus = value match {
    case software.amazon.awssdk.services.accessanalyzer.model.JobStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.accessanalyzer.model.JobStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.accessanalyzer.model.JobStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.accessanalyzer.model.JobStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.accessanalyzer.model.JobStatus.CANCELED =>
      val r = CANCELED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.accessanalyzer.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.JobStatus =
      software.amazon.awssdk.services.accessanalyzer.model.JobStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object IN_PROGRESS extends zio.aws.accessanalyzer.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.JobStatus =
      software.amazon.awssdk.services.accessanalyzer.model.JobStatus.IN_PROGRESS
  }
  case object SUCCEEDED extends zio.aws.accessanalyzer.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.JobStatus =
      software.amazon.awssdk.services.accessanalyzer.model.JobStatus.SUCCEEDED
  }
  case object FAILED extends zio.aws.accessanalyzer.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.JobStatus =
      software.amazon.awssdk.services.accessanalyzer.model.JobStatus.FAILED
  }
  case object CANCELED extends zio.aws.accessanalyzer.model.JobStatus {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.JobStatus =
      software.amazon.awssdk.services.accessanalyzer.model.JobStatus.CANCELED
  }
}
