package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class Substring(length: Integer, start: Integer) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.Substring = {
    import Substring.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.Substring
      .builder()
      .length(length: java.lang.Integer)
      .start(start: java.lang.Integer)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.Substring.ReadOnly =
    zio.aws.accessanalyzer.model.Substring.wrap(buildAwsValue())
}
object Substring {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.Substring
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.Substring =
      zio.aws.accessanalyzer.model.Substring(length, start)
    def length: Integer
    def start: Integer
    def getLength: ZIO[Any, Nothing, Integer] = ZIO.succeed(length)
    def getStart: ZIO[Any, Nothing, Integer] = ZIO.succeed(start)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.Substring
  ) extends zio.aws.accessanalyzer.model.Substring.ReadOnly {
    override val length: Integer = impl.length(): Integer
    override val start: Integer = impl.start(): Integer
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.Substring
  ): zio.aws.accessanalyzer.model.Substring.ReadOnly = new Wrapper(impl)
}
