package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.{Token, Integer, AnalyzerArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListFindingsRequest(
    analyzerArn: AnalyzerArn,
    filter: Optional[Map[String, zio.aws.accessanalyzer.model.Criterion]] =
      Optional.Absent,
    maxResults: Optional[Integer] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent,
    sort: Optional[zio.aws.accessanalyzer.model.SortCriteria] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.ListFindingsRequest = {
    import ListFindingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.ListFindingsRequest
      .builder()
      .analyzerArn(AnalyzerArn.unwrap(analyzerArn): java.lang.String)
      .optionallyWith(
        filter.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.filter)
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(sort.map(value => value.buildAwsValue()))(_.sort)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.ListFindingsRequest.ReadOnly =
    zio.aws.accessanalyzer.model.ListFindingsRequest.wrap(buildAwsValue())
}
object ListFindingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.ListFindingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.ListFindingsRequest =
      zio.aws.accessanalyzer.model.ListFindingsRequest(
        analyzerArn,
        filter.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        maxResults.map(value => value),
        nextToken.map(value => value),
        sort.map(value => value.asEditable)
      )
    def analyzerArn: AnalyzerArn
    def filter
        : Optional[Map[String, zio.aws.accessanalyzer.model.Criterion.ReadOnly]]
    def maxResults: Optional[Integer]
    def nextToken: Optional[Token]
    def sort: Optional[zio.aws.accessanalyzer.model.SortCriteria.ReadOnly]
    def getAnalyzerArn: ZIO[Any, Nothing, AnalyzerArn] =
      ZIO.succeed(analyzerArn)
    def getFilter: ZIO[Any, AwsError, Map[
      String,
      zio.aws.accessanalyzer.model.Criterion.ReadOnly
    ]] = AwsError.unwrapOptionField("filter", filter)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSort: ZIO[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.SortCriteria.ReadOnly
    ] = AwsError.unwrapOptionField("sort", sort)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ListFindingsRequest
  ) extends zio.aws.accessanalyzer.model.ListFindingsRequest.ReadOnly {
    override val analyzerArn: AnalyzerArn =
      zio.aws.accessanalyzer.model.primitives.AnalyzerArn(impl.analyzerArn())
    override val filter: Optional[
      Map[String, zio.aws.accessanalyzer.model.Criterion.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filter())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> zio.aws.accessanalyzer.model.Criterion.wrap(value)
          })
          .toMap
      )
    override val maxResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: Integer)
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.accessanalyzer.model.primitives.Token(value))
    override val sort
        : Optional[zio.aws.accessanalyzer.model.SortCriteria.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sort())
        .map(value => zio.aws.accessanalyzer.model.SortCriteria.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ListFindingsRequest
  ): zio.aws.accessanalyzer.model.ListFindingsRequest.ReadOnly = new Wrapper(
    impl
  )
}
