package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.Name
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateArchiveRuleRequest(
    analyzerName: Name,
    clientToken: Optional[String] = Optional.Absent,
    filter: Map[String, zio.aws.accessanalyzer.model.Criterion],
    ruleName: Name
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.UpdateArchiveRuleRequest = {
    import UpdateArchiveRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.UpdateArchiveRuleRequest
      .builder()
      .analyzerName(Name.unwrap(analyzerName): java.lang.String)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .filter(
        filter
          .map({ case (key, value) =>
            (key: java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .ruleName(Name.unwrap(ruleName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.UpdateArchiveRuleRequest.ReadOnly =
    zio.aws.accessanalyzer.model.UpdateArchiveRuleRequest.wrap(buildAwsValue())
}
object UpdateArchiveRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.UpdateArchiveRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.UpdateArchiveRuleRequest =
      zio.aws.accessanalyzer.model.UpdateArchiveRuleRequest(
        analyzerName,
        clientToken.map(value => value),
        filter.map({ case (key, value) =>
          key -> value.asEditable
        }),
        ruleName
      )
    def analyzerName: Name
    def clientToken: Optional[String]
    def filter: Map[String, zio.aws.accessanalyzer.model.Criterion.ReadOnly]
    def ruleName: Name
    def getAnalyzerName: ZIO[Any, Nothing, Name] = ZIO.succeed(analyzerName)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getFilter: ZIO[Any, Nothing, Map[
      String,
      zio.aws.accessanalyzer.model.Criterion.ReadOnly
    ]] = ZIO.succeed(filter)
    def getRuleName: ZIO[Any, Nothing, Name] = ZIO.succeed(ruleName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.UpdateArchiveRuleRequest
  ) extends zio.aws.accessanalyzer.model.UpdateArchiveRuleRequest.ReadOnly {
    override val analyzerName: Name =
      zio.aws.accessanalyzer.model.primitives.Name(impl.analyzerName())
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val filter
        : Map[String, zio.aws.accessanalyzer.model.Criterion.ReadOnly] = impl
      .filter()
      .asScala
      .map({ case (key, value) =>
        (key: String) -> zio.aws.accessanalyzer.model.Criterion.wrap(value)
      })
      .toMap
    override val ruleName: Name =
      zio.aws.accessanalyzer.model.primitives.Name(impl.ruleName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.UpdateArchiveRuleRequest
  ): zio.aws.accessanalyzer.model.UpdateArchiveRuleRequest.ReadOnly =
    new Wrapper(impl)
}
