package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.Token
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListFindingsResponse(
    findings: Iterable[zio.aws.accessanalyzer.model.FindingSummary],
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.ListFindingsResponse = {
    import ListFindingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.ListFindingsResponse
      .builder()
      .findings(findings.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.ListFindingsResponse.ReadOnly =
    zio.aws.accessanalyzer.model.ListFindingsResponse.wrap(buildAwsValue())
}
object ListFindingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.ListFindingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.ListFindingsResponse =
      zio.aws.accessanalyzer.model.ListFindingsResponse(
        findings.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def findings: List[zio.aws.accessanalyzer.model.FindingSummary.ReadOnly]
    def nextToken: Optional[Token]
    def getFindings: ZIO[Any, Nothing, List[
      zio.aws.accessanalyzer.model.FindingSummary.ReadOnly
    ]] = ZIO.succeed(findings)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ListFindingsResponse
  ) extends zio.aws.accessanalyzer.model.ListFindingsResponse.ReadOnly {
    override val findings
        : List[zio.aws.accessanalyzer.model.FindingSummary.ReadOnly] = impl
      .findings()
      .asScala
      .map { item =>
        zio.aws.accessanalyzer.model.FindingSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.accessanalyzer.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ListFindingsResponse
  ): zio.aws.accessanalyzer.model.ListFindingsResponse.ReadOnly = new Wrapper(
    impl
  )
}
