package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.Name
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetArchiveRuleRequest(analyzerName: Name, ruleName: Name) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.GetArchiveRuleRequest = {
    import GetArchiveRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.GetArchiveRuleRequest
      .builder()
      .analyzerName(Name.unwrap(analyzerName): java.lang.String)
      .ruleName(Name.unwrap(ruleName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.GetArchiveRuleRequest.ReadOnly =
    zio.aws.accessanalyzer.model.GetArchiveRuleRequest.wrap(buildAwsValue())
}
object GetArchiveRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.GetArchiveRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.GetArchiveRuleRequest =
      zio.aws.accessanalyzer.model.GetArchiveRuleRequest(analyzerName, ruleName)
    def analyzerName: Name
    def ruleName: Name
    def getAnalyzerName: ZIO[Any, Nothing, Name] = ZIO.succeed(analyzerName)
    def getRuleName: ZIO[Any, Nothing, Name] = ZIO.succeed(ruleName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.GetArchiveRuleRequest
  ) extends zio.aws.accessanalyzer.model.GetArchiveRuleRequest.ReadOnly {
    override val analyzerName: Name =
      zio.aws.accessanalyzer.model.primitives.Name(impl.analyzerName())
    override val ruleName: Name =
      zio.aws.accessanalyzer.model.primitives.Name(impl.ruleName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.GetArchiveRuleRequest
  ): zio.aws.accessanalyzer.model.GetArchiveRuleRequest.ReadOnly = new Wrapper(
    impl
  )
}
