package zio.aws.accessanalyzer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Configuration(
    iamRole: Optional[zio.aws.accessanalyzer.model.IamRoleConfiguration] =
      Optional.Absent,
    kmsKey: Optional[zio.aws.accessanalyzer.model.KmsKeyConfiguration] =
      Optional.Absent,
    s3Bucket: Optional[zio.aws.accessanalyzer.model.S3BucketConfiguration] =
      Optional.Absent,
    secretsManagerSecret: Optional[
      zio.aws.accessanalyzer.model.SecretsManagerSecretConfiguration
    ] = Optional.Absent,
    sqsQueue: Optional[zio.aws.accessanalyzer.model.SqsQueueConfiguration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.Configuration = {
    import Configuration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.Configuration
      .builder()
      .optionallyWith(iamRole.map(value => value.buildAwsValue()))(_.iamRole)
      .optionallyWith(kmsKey.map(value => value.buildAwsValue()))(_.kmsKey)
      .optionallyWith(s3Bucket.map(value => value.buildAwsValue()))(_.s3Bucket)
      .optionallyWith(secretsManagerSecret.map(value => value.buildAwsValue()))(
        _.secretsManagerSecret
      )
      .optionallyWith(sqsQueue.map(value => value.buildAwsValue()))(_.sqsQueue)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.Configuration.ReadOnly =
    zio.aws.accessanalyzer.model.Configuration.wrap(buildAwsValue())
}
object Configuration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.Configuration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.Configuration =
      zio.aws.accessanalyzer.model.Configuration(
        iamRole.map(value => value.asEditable),
        kmsKey.map(value => value.asEditable),
        s3Bucket.map(value => value.asEditable),
        secretsManagerSecret.map(value => value.asEditable),
        sqsQueue.map(value => value.asEditable)
      )
    def iamRole
        : Optional[zio.aws.accessanalyzer.model.IamRoleConfiguration.ReadOnly]
    def kmsKey
        : Optional[zio.aws.accessanalyzer.model.KmsKeyConfiguration.ReadOnly]
    def s3Bucket
        : Optional[zio.aws.accessanalyzer.model.S3BucketConfiguration.ReadOnly]
    def secretsManagerSecret: Optional[
      zio.aws.accessanalyzer.model.SecretsManagerSecretConfiguration.ReadOnly
    ]
    def sqsQueue
        : Optional[zio.aws.accessanalyzer.model.SqsQueueConfiguration.ReadOnly]
    def getIamRole: ZIO[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.IamRoleConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("iamRole", iamRole)
    def getKmsKey: ZIO[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.KmsKeyConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("kmsKey", kmsKey)
    def getS3Bucket: ZIO[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.S3BucketConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("s3Bucket", s3Bucket)
    def getSecretsManagerSecret: ZIO[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.SecretsManagerSecretConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("secretsManagerSecret", secretsManagerSecret)
    def getSqsQueue: ZIO[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.SqsQueueConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("sqsQueue", sqsQueue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.Configuration
  ) extends zio.aws.accessanalyzer.model.Configuration.ReadOnly {
    override val iamRole
        : Optional[zio.aws.accessanalyzer.model.IamRoleConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iamRole())
        .map(value =>
          zio.aws.accessanalyzer.model.IamRoleConfiguration.wrap(value)
        )
    override val kmsKey
        : Optional[zio.aws.accessanalyzer.model.KmsKeyConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kmsKey())
        .map(value =>
          zio.aws.accessanalyzer.model.KmsKeyConfiguration.wrap(value)
        )
    override val s3Bucket: Optional[
      zio.aws.accessanalyzer.model.S3BucketConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Bucket())
      .map(value =>
        zio.aws.accessanalyzer.model.S3BucketConfiguration.wrap(value)
      )
    override val secretsManagerSecret: Optional[
      zio.aws.accessanalyzer.model.SecretsManagerSecretConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.secretsManagerSecret())
      .map(value =>
        zio.aws.accessanalyzer.model.SecretsManagerSecretConfiguration
          .wrap(value)
      )
    override val sqsQueue: Optional[
      zio.aws.accessanalyzer.model.SqsQueueConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sqsQueue())
      .map(value =>
        zio.aws.accessanalyzer.model.SqsQueueConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.Configuration
  ): zio.aws.accessanalyzer.model.Configuration.ReadOnly = new Wrapper(impl)
}
