package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.AnalyzerArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateAnalyzerResponse(
    arn: Optional[AnalyzerArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.CreateAnalyzerResponse = {
    import CreateAnalyzerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.CreateAnalyzerResponse
      .builder()
      .optionallyWith(
        arn.map(value => AnalyzerArn.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.CreateAnalyzerResponse.ReadOnly =
    zio.aws.accessanalyzer.model.CreateAnalyzerResponse.wrap(buildAwsValue())
}
object CreateAnalyzerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.CreateAnalyzerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.CreateAnalyzerResponse =
      zio.aws.accessanalyzer.model
        .CreateAnalyzerResponse(arn.map(value => value))
    def arn: Optional[AnalyzerArn]
    def getArn: ZIO[Any, AwsError, AnalyzerArn] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.CreateAnalyzerResponse
  ) extends zio.aws.accessanalyzer.model.CreateAnalyzerResponse.ReadOnly {
    override val arn: Optional[AnalyzerArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.accessanalyzer.model.primitives.AnalyzerArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.CreateAnalyzerResponse
  ): zio.aws.accessanalyzer.model.CreateAnalyzerResponse.ReadOnly = new Wrapper(
    impl
  )
}
