package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.Token
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListAnalyzersResponse(
    analyzers: Iterable[zio.aws.accessanalyzer.model.AnalyzerSummary],
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzersResponse = {
    import ListAnalyzersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzersResponse
      .builder()
      .analyzers(analyzers.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.ListAnalyzersResponse.ReadOnly =
    zio.aws.accessanalyzer.model.ListAnalyzersResponse.wrap(buildAwsValue())
}
object ListAnalyzersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.ListAnalyzersResponse =
      zio.aws.accessanalyzer.model.ListAnalyzersResponse(
        analyzers.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def analyzers: List[zio.aws.accessanalyzer.model.AnalyzerSummary.ReadOnly]
    def nextToken: Optional[Token]
    def getAnalyzers: ZIO[Any, Nothing, List[
      zio.aws.accessanalyzer.model.AnalyzerSummary.ReadOnly
    ]] = ZIO.succeed(analyzers)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzersResponse
  ) extends zio.aws.accessanalyzer.model.ListAnalyzersResponse.ReadOnly {
    override val analyzers
        : List[zio.aws.accessanalyzer.model.AnalyzerSummary.ReadOnly] = impl
      .analyzers()
      .asScala
      .map { item =>
        zio.aws.accessanalyzer.model.AnalyzerSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.accessanalyzer.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzersResponse
  ): zio.aws.accessanalyzer.model.ListAnalyzersResponse.ReadOnly = new Wrapper(
    impl
  )
}
