package zio.aws.accessanalyzer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FindingSourceDetail(
    accessPointArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.FindingSourceDetail = {
    import FindingSourceDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.FindingSourceDetail
      .builder()
      .optionallyWith(accessPointArn.map(value => value: java.lang.String))(
        _.accessPointArn
      )
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.FindingSourceDetail.ReadOnly =
    zio.aws.accessanalyzer.model.FindingSourceDetail.wrap(buildAwsValue())
}
object FindingSourceDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.FindingSourceDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.FindingSourceDetail =
      zio.aws.accessanalyzer.model
        .FindingSourceDetail(accessPointArn.map(value => value))
    def accessPointArn: Optional[String]
    def getAccessPointArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("accessPointArn", accessPointArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.FindingSourceDetail
  ) extends zio.aws.accessanalyzer.model.FindingSourceDetail.ReadOnly {
    override val accessPointArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.accessPointArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.FindingSourceDetail
  ): zio.aws.accessanalyzer.model.FindingSourceDetail.ReadOnly = new Wrapper(
    impl
  )
}
