package zio.aws.accessanalyzer.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.accessanalyzer.model.primitives.{
  AccessPreviewId,
  Timestamp,
  AnalyzerArn
}
import scala.jdk.CollectionConverters.*
final case class AccessPreviewSummary(
    analyzerArn: AnalyzerArn,
    createdAt: Timestamp,
    id: AccessPreviewId,
    status: zio.aws.accessanalyzer.model.AccessPreviewStatus,
    statusReason: Optional[
      zio.aws.accessanalyzer.model.AccessPreviewStatusReason
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.AccessPreviewSummary = {
    import AccessPreviewSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.AccessPreviewSummary
      .builder()
      .analyzerArn(AnalyzerArn.unwrap(analyzerArn): java.lang.String)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .id(AccessPreviewId.unwrap(id): java.lang.String)
      .status(status.unwrap)
      .optionallyWith(statusReason.map(value => value.buildAwsValue()))(
        _.statusReason
      )
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.AccessPreviewSummary.ReadOnly =
    zio.aws.accessanalyzer.model.AccessPreviewSummary.wrap(buildAwsValue())
}
object AccessPreviewSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.AccessPreviewSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.AccessPreviewSummary =
      zio.aws.accessanalyzer.model.AccessPreviewSummary(
        analyzerArn,
        createdAt,
        id,
        status,
        statusReason.map(value => value.asEditable)
      )
    def analyzerArn: AnalyzerArn
    def createdAt: Timestamp
    def id: AccessPreviewId
    def status: zio.aws.accessanalyzer.model.AccessPreviewStatus
    def statusReason: Optional[
      zio.aws.accessanalyzer.model.AccessPreviewStatusReason.ReadOnly
    ]
    def getAnalyzerArn: ZIO[Any, Nothing, AnalyzerArn] =
      ZIO.succeed(analyzerArn)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getId: ZIO[Any, Nothing, AccessPreviewId] = ZIO.succeed(id)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.accessanalyzer.model.AccessPreviewStatus] =
      ZIO.succeed(status)
    def getStatusReason: ZIO[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.AccessPreviewStatusReason.ReadOnly
    ] = AwsError.unwrapOptionField("statusReason", statusReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.AccessPreviewSummary
  ) extends zio.aws.accessanalyzer.model.AccessPreviewSummary.ReadOnly {
    override val analyzerArn: AnalyzerArn =
      zio.aws.accessanalyzer.model.primitives.AnalyzerArn(impl.analyzerArn())
    override val createdAt: Timestamp =
      zio.aws.accessanalyzer.model.primitives.Timestamp(impl.createdAt())
    override val id: AccessPreviewId =
      zio.aws.accessanalyzer.model.primitives.AccessPreviewId(impl.id())
    override val status: zio.aws.accessanalyzer.model.AccessPreviewStatus =
      zio.aws.accessanalyzer.model.AccessPreviewStatus.wrap(impl.status())
    override val statusReason: Optional[
      zio.aws.accessanalyzer.model.AccessPreviewStatusReason.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.statusReason())
      .map(value =>
        zio.aws.accessanalyzer.model.AccessPreviewStatusReason.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.AccessPreviewSummary
  ): zio.aws.accessanalyzer.model.AccessPreviewSummary.ReadOnly = new Wrapper(
    impl
  )
}
