package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.{Name, Timestamp}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ArchiveRuleSummary(
    createdAt: Timestamp,
    filter: Map[String, zio.aws.accessanalyzer.model.Criterion],
    ruleName: Name,
    updatedAt: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.ArchiveRuleSummary = {
    import ArchiveRuleSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.ArchiveRuleSummary
      .builder()
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .filter(
        filter
          .map({ case (key, value) =>
            (key: java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .ruleName(Name.unwrap(ruleName): java.lang.String)
      .updatedAt(Timestamp.unwrap(updatedAt): Instant)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.ArchiveRuleSummary.ReadOnly =
    zio.aws.accessanalyzer.model.ArchiveRuleSummary.wrap(buildAwsValue())
}
object ArchiveRuleSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.ArchiveRuleSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.ArchiveRuleSummary =
      zio.aws.accessanalyzer.model.ArchiveRuleSummary(
        createdAt,
        filter.map({ case (key, value) =>
          key -> value.asEditable
        }),
        ruleName,
        updatedAt
      )
    def createdAt: Timestamp
    def filter: Map[String, zio.aws.accessanalyzer.model.Criterion.ReadOnly]
    def ruleName: Name
    def updatedAt: Timestamp
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getFilter: ZIO[Any, Nothing, Map[
      String,
      zio.aws.accessanalyzer.model.Criterion.ReadOnly
    ]] = ZIO.succeed(filter)
    def getRuleName: ZIO[Any, Nothing, Name] = ZIO.succeed(ruleName)
    def getUpdatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ArchiveRuleSummary
  ) extends zio.aws.accessanalyzer.model.ArchiveRuleSummary.ReadOnly {
    override val createdAt: Timestamp =
      zio.aws.accessanalyzer.model.primitives.Timestamp(impl.createdAt())
    override val filter
        : Map[String, zio.aws.accessanalyzer.model.Criterion.ReadOnly] = impl
      .filter()
      .asScala
      .map({ case (key, value) =>
        (key: String) -> zio.aws.accessanalyzer.model.Criterion.wrap(value)
      })
      .toMap
    override val ruleName: Name =
      zio.aws.accessanalyzer.model.primitives.Name(impl.ruleName())
    override val updatedAt: Timestamp =
      zio.aws.accessanalyzer.model.primitives.Timestamp(impl.updatedAt())
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ArchiveRuleSummary
  ): zio.aws.accessanalyzer.model.ArchiveRuleSummary.ReadOnly = new Wrapper(
    impl
  )
}
