package zio.aws.accessanalyzer.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class S3PublicAccessBlockConfiguration(
    ignorePublicAcls: Boolean,
    restrictPublicBuckets: Boolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.S3PublicAccessBlockConfiguration = {
    import S3PublicAccessBlockConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.S3PublicAccessBlockConfiguration
      .builder()
      .ignorePublicAcls(ignorePublicAcls: java.lang.Boolean)
      .restrictPublicBuckets(restrictPublicBuckets: java.lang.Boolean)
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.S3PublicAccessBlockConfiguration.ReadOnly =
    zio.aws.accessanalyzer.model.S3PublicAccessBlockConfiguration
      .wrap(buildAwsValue())
}
object S3PublicAccessBlockConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.S3PublicAccessBlockConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.accessanalyzer.model.S3PublicAccessBlockConfiguration =
      zio.aws.accessanalyzer.model.S3PublicAccessBlockConfiguration(
        ignorePublicAcls,
        restrictPublicBuckets
      )
    def ignorePublicAcls: Boolean
    def restrictPublicBuckets: Boolean
    def getIgnorePublicAcls: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(ignorePublicAcls)
    def getRestrictPublicBuckets: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(restrictPublicBuckets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.S3PublicAccessBlockConfiguration
  ) extends zio.aws.accessanalyzer.model.S3PublicAccessBlockConfiguration.ReadOnly {
    override val ignorePublicAcls: Boolean = impl.ignorePublicAcls(): Boolean
    override val restrictPublicBuckets: Boolean =
      impl.restrictPublicBuckets(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.S3PublicAccessBlockConfiguration
  ): zio.aws.accessanalyzer.model.S3PublicAccessBlockConfiguration.ReadOnly =
    new Wrapper(impl)
}
