package zio.aws.accessanalyzer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FindingSource(
    detail: Optional[zio.aws.accessanalyzer.model.FindingSourceDetail] =
      Optional.Absent,
    `type`: zio.aws.accessanalyzer.model.FindingSourceType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.FindingSource = {
    import FindingSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.FindingSource
      .builder()
      .optionallyWith(detail.map(value => value.buildAwsValue()))(_.detail)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.FindingSource.ReadOnly =
    zio.aws.accessanalyzer.model.FindingSource.wrap(buildAwsValue())
}
object FindingSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.FindingSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.FindingSource =
      zio.aws.accessanalyzer.model
        .FindingSource(detail.map(value => value.asEditable), `type`)
    def detail
        : Optional[zio.aws.accessanalyzer.model.FindingSourceDetail.ReadOnly]
    def `type`: zio.aws.accessanalyzer.model.FindingSourceType
    def getDetail: ZIO[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.FindingSourceDetail.ReadOnly
    ] = AwsError.unwrapOptionField("detail", detail)
    def getType
        : ZIO[Any, Nothing, zio.aws.accessanalyzer.model.FindingSourceType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.FindingSource
  ) extends zio.aws.accessanalyzer.model.FindingSource.ReadOnly {
    override val detail
        : Optional[zio.aws.accessanalyzer.model.FindingSourceDetail.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.detail())
        .map(value =>
          zio.aws.accessanalyzer.model.FindingSourceDetail.wrap(value)
        )
    override val `type`: zio.aws.accessanalyzer.model.FindingSourceType =
      zio.aws.accessanalyzer.model.FindingSourceType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.FindingSource
  ): zio.aws.accessanalyzer.model.FindingSource.ReadOnly = new Wrapper(impl)
}
