package zio.aws.accessanalyzer.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.accessanalyzer.model.primitives.{ResourceArn, Timestamp}
import scala.jdk.CollectionConverters.*
final case class AnalyzedResource(
    actions: Optional[Iterable[String]] = Optional.Absent,
    analyzedAt: Timestamp,
    createdAt: Timestamp,
    error: Optional[String] = Optional.Absent,
    isPublic: Boolean,
    resourceArn: ResourceArn,
    resourceOwnerAccount: String,
    resourceType: zio.aws.accessanalyzer.model.ResourceType,
    sharedVia: Optional[Iterable[String]] = Optional.Absent,
    status: Optional[zio.aws.accessanalyzer.model.FindingStatus] =
      Optional.Absent,
    updatedAt: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.AnalyzedResource = {
    import AnalyzedResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.AnalyzedResource
      .builder()
      .optionallyWith(
        actions.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.actions)
      .analyzedAt(Timestamp.unwrap(analyzedAt): Instant)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .optionallyWith(error.map(value => value: java.lang.String))(_.error)
      .isPublic(isPublic: java.lang.Boolean)
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .resourceOwnerAccount(resourceOwnerAccount: java.lang.String)
      .resourceType(resourceType.unwrap)
      .optionallyWith(
        sharedVia.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.sharedVia)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .updatedAt(Timestamp.unwrap(updatedAt): Instant)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.AnalyzedResource.ReadOnly =
    zio.aws.accessanalyzer.model.AnalyzedResource.wrap(buildAwsValue())
}
object AnalyzedResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.AnalyzedResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.AnalyzedResource =
      zio.aws.accessanalyzer.model.AnalyzedResource(
        actions.map(value => value),
        analyzedAt,
        createdAt,
        error.map(value => value),
        isPublic,
        resourceArn,
        resourceOwnerAccount,
        resourceType,
        sharedVia.map(value => value),
        status.map(value => value),
        updatedAt
      )
    def actions: Optional[List[String]]
    def analyzedAt: Timestamp
    def createdAt: Timestamp
    def error: Optional[String]
    def isPublic: Boolean
    def resourceArn: ResourceArn
    def resourceOwnerAccount: String
    def resourceType: zio.aws.accessanalyzer.model.ResourceType
    def sharedVia: Optional[List[String]]
    def status: Optional[zio.aws.accessanalyzer.model.FindingStatus]
    def updatedAt: Timestamp
    def getActions: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("actions", actions)
    def getAnalyzedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(analyzedAt)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getError: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("error", error)
    def getIsPublic: ZIO[Any, Nothing, Boolean] = ZIO.succeed(isPublic)
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
    def getResourceOwnerAccount: ZIO[Any, Nothing, String] =
      ZIO.succeed(resourceOwnerAccount)
    def getResourceType
        : ZIO[Any, Nothing, zio.aws.accessanalyzer.model.ResourceType] =
      ZIO.succeed(resourceType)
    def getSharedVia: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("sharedVia", sharedVia)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.accessanalyzer.model.FindingStatus] =
      AwsError.unwrapOptionField("status", status)
    def getUpdatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.AnalyzedResource
  ) extends zio.aws.accessanalyzer.model.AnalyzedResource.ReadOnly {
    override val actions: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.actions())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val analyzedAt: Timestamp =
      zio.aws.accessanalyzer.model.primitives.Timestamp(impl.analyzedAt())
    override val createdAt: Timestamp =
      zio.aws.accessanalyzer.model.primitives.Timestamp(impl.createdAt())
    override val error: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.error())
      .map(value => value: String)
    override val isPublic: Boolean = impl.isPublic(): Boolean
    override val resourceArn: ResourceArn =
      zio.aws.accessanalyzer.model.primitives.ResourceArn(impl.resourceArn())
    override val resourceOwnerAccount: String =
      impl.resourceOwnerAccount(): String
    override val resourceType: zio.aws.accessanalyzer.model.ResourceType =
      zio.aws.accessanalyzer.model.ResourceType.wrap(impl.resourceType())
    override val sharedVia: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.sharedVia())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val status: Optional[zio.aws.accessanalyzer.model.FindingStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.accessanalyzer.model.FindingStatus.wrap(value))
    override val updatedAt: Timestamp =
      zio.aws.accessanalyzer.model.primitives.Timestamp(impl.updatedAt())
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.AnalyzedResource
  ): zio.aws.accessanalyzer.model.AnalyzedResource.ReadOnly = new Wrapper(impl)
}
