package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.{AclUri, AclCanonicalId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AclGrantee(
    id: Option[AclCanonicalId] = None,
    uri: Option[AclUri] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.AclGrantee = {
    import AclGrantee.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.AclGrantee
      .builder()
      .optionallyWith(
        id.map(value => AclCanonicalId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(uri.map(value => AclUri.unwrap(value): java.lang.String))(
        _.uri
      )
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.AclGrantee.ReadOnly =
    zio.aws.accessanalyzer.model.AclGrantee.wrap(buildAwsValue())
}
object AclGrantee {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.AclGrantee
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.AclGrantee =
      zio.aws.accessanalyzer.model
        .AclGrantee(id.map(value => value), uri.map(value => value))
    def id: Option[AclCanonicalId]
    def uri: Option[AclUri]
    def getId: ZIO[Any, AwsError, AclCanonicalId] =
      AwsError.unwrapOptionField("id", id)
    def getUri: ZIO[Any, AwsError, AclUri] =
      AwsError.unwrapOptionField("uri", uri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.AclGrantee
  ) extends zio.aws.accessanalyzer.model.AclGrantee.ReadOnly {
    override val id: Option[AclCanonicalId] = scala
      .Option(impl.id())
      .map(value =>
        zio.aws.accessanalyzer.model.primitives.AclCanonicalId(value)
      )
    override val uri: Option[AclUri] = scala
      .Option(impl.uri())
      .map(value => zio.aws.accessanalyzer.model.primitives.AclUri(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.AclGrantee
  ): zio.aws.accessanalyzer.model.AclGrantee.ReadOnly = new Wrapper(impl)
}
