package zio.aws.accessanalyzer.model
import scala.jdk.CollectionConverters.*
sealed trait ResourceType {
  def unwrap: software.amazon.awssdk.services.accessanalyzer.model.ResourceType
}
object ResourceType {
  def wrap(
      value: software.amazon.awssdk.services.accessanalyzer.model.ResourceType
  ): zio.aws.accessanalyzer.model.ResourceType = value match {
    case software.amazon.awssdk.services.accessanalyzer.model.ResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.accessanalyzer.model.ResourceType.AWS_S3_BUCKET =>
      val r = `AWS::S3::Bucket`
      r
    case software.amazon.awssdk.services.accessanalyzer.model.ResourceType.AWS_IAM_ROLE =>
      val r = `AWS::IAM::Role`
      r
    case software.amazon.awssdk.services.accessanalyzer.model.ResourceType.AWS_SQS_QUEUE =>
      val r = `AWS::SQS::Queue`
      r
    case software.amazon.awssdk.services.accessanalyzer.model.ResourceType.AWS_LAMBDA_FUNCTION =>
      val r = `AWS::Lambda::Function`
      r
    case software.amazon.awssdk.services.accessanalyzer.model.ResourceType.AWS_LAMBDA_LAYER_VERSION =>
      val r = `AWS::Lambda::LayerVersion`
      r
    case software.amazon.awssdk.services.accessanalyzer.model.ResourceType.AWS_KMS_KEY =>
      val r = `AWS::KMS::Key`
      r
    case software.amazon.awssdk.services.accessanalyzer.model.ResourceType.AWS_SECRETS_MANAGER_SECRET =>
      val r = `AWS::SecretsManager::Secret`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.accessanalyzer.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.ResourceType =
      software.amazon.awssdk.services.accessanalyzer.model.ResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object `AWS::S3::Bucket`
      extends zio.aws.accessanalyzer.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.ResourceType =
      software.amazon.awssdk.services.accessanalyzer.model.ResourceType.AWS_S3_BUCKET
  }
  case object `AWS::IAM::Role`
      extends zio.aws.accessanalyzer.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.ResourceType =
      software.amazon.awssdk.services.accessanalyzer.model.ResourceType.AWS_IAM_ROLE
  }
  case object `AWS::SQS::Queue`
      extends zio.aws.accessanalyzer.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.ResourceType =
      software.amazon.awssdk.services.accessanalyzer.model.ResourceType.AWS_SQS_QUEUE
  }
  case object `AWS::Lambda::Function`
      extends zio.aws.accessanalyzer.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.ResourceType =
      software.amazon.awssdk.services.accessanalyzer.model.ResourceType.AWS_LAMBDA_FUNCTION
  }
  case object `AWS::Lambda::LayerVersion`
      extends zio.aws.accessanalyzer.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.ResourceType =
      software.amazon.awssdk.services.accessanalyzer.model.ResourceType.AWS_LAMBDA_LAYER_VERSION
  }
  case object `AWS::KMS::Key`
      extends zio.aws.accessanalyzer.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.ResourceType =
      software.amazon.awssdk.services.accessanalyzer.model.ResourceType.AWS_KMS_KEY
  }
  case object `AWS::SecretsManager::Secret`
      extends zio.aws.accessanalyzer.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.ResourceType =
      software.amazon.awssdk.services.accessanalyzer.model.ResourceType.AWS_SECRETS_MANAGER_SECRET
  }
}
