package zio.aws.accessanalyzer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceResponse(
    tags: Option[Map[String, String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.ListTagsForResourceResponse
      .builder()
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.ListTagsForResourceResponse.ReadOnly =
    zio.aws.accessanalyzer.model.ListTagsForResourceResponse
      .wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.ListTagsForResourceResponse =
      zio.aws.accessanalyzer.model
        .ListTagsForResourceResponse(tags.map(value => value))
    def tags: Option[Map[String, String]]
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ListTagsForResourceResponse
  ) extends zio.aws.accessanalyzer.model.ListTagsForResourceResponse.ReadOnly {
    override val tags: Option[Map[String, String]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ListTagsForResourceResponse
  ): zio.aws.accessanalyzer.model.ListTagsForResourceResponse.ReadOnly =
    new Wrapper(impl)
}
