package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.Token
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListAnalyzedResourcesResponse(
    analyzedResources: Iterable[
      zio.aws.accessanalyzer.model.AnalyzedResourceSummary
    ],
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzedResourcesResponse = {
    import ListAnalyzedResourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzedResourcesResponse
      .builder()
      .analyzedResources(analyzedResources.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.ListAnalyzedResourcesResponse.ReadOnly =
    zio.aws.accessanalyzer.model.ListAnalyzedResourcesResponse
      .wrap(buildAwsValue())
}
object ListAnalyzedResourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzedResourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.ListAnalyzedResourcesResponse =
      zio.aws.accessanalyzer.model.ListAnalyzedResourcesResponse(
        analyzedResources.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def analyzedResources
        : List[zio.aws.accessanalyzer.model.AnalyzedResourceSummary.ReadOnly]
    def nextToken: Option[Token]
    def getAnalyzedResources: ZIO[Any, Nothing, List[
      zio.aws.accessanalyzer.model.AnalyzedResourceSummary.ReadOnly
    ]] = ZIO.succeed(analyzedResources)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzedResourcesResponse
  ) extends zio.aws.accessanalyzer.model.ListAnalyzedResourcesResponse.ReadOnly {
    override val analyzedResources
        : List[zio.aws.accessanalyzer.model.AnalyzedResourceSummary.ReadOnly] =
      impl
        .analyzedResources()
        .asScala
        .map { item =>
          zio.aws.accessanalyzer.model.AnalyzedResourceSummary.wrap(item)
        }
        .toList
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.accessanalyzer.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzedResourcesResponse
  ): zio.aws.accessanalyzer.model.ListAnalyzedResourcesResponse.ReadOnly =
    new Wrapper(impl)
}
