package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.Name
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteArchiveRuleRequest(
    analyzerName: Name,
    clientToken: Option[String] = None,
    ruleName: Name
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.DeleteArchiveRuleRequest = {
    import DeleteArchiveRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.DeleteArchiveRuleRequest
      .builder()
      .analyzerName(Name.unwrap(analyzerName): java.lang.String)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .ruleName(Name.unwrap(ruleName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.DeleteArchiveRuleRequest.ReadOnly =
    zio.aws.accessanalyzer.model.DeleteArchiveRuleRequest.wrap(buildAwsValue())
}
object DeleteArchiveRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.DeleteArchiveRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.DeleteArchiveRuleRequest =
      zio.aws.accessanalyzer.model.DeleteArchiveRuleRequest(
        analyzerName,
        clientToken.map(value => value),
        ruleName
      )
    def analyzerName: Name
    def clientToken: Option[String]
    def ruleName: Name
    def getAnalyzerName: ZIO[Any, Nothing, Name] = ZIO.succeed(analyzerName)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getRuleName: ZIO[Any, Nothing, Name] = ZIO.succeed(ruleName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.DeleteArchiveRuleRequest
  ) extends zio.aws.accessanalyzer.model.DeleteArchiveRuleRequest.ReadOnly {
    override val analyzerName: Name =
      zio.aws.accessanalyzer.model.primitives.Name(impl.analyzerName())
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
    override val ruleName: Name =
      zio.aws.accessanalyzer.model.primitives.Name(impl.ruleName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.DeleteArchiveRuleRequest
  ): zio.aws.accessanalyzer.model.DeleteArchiveRuleRequest.ReadOnly =
    new Wrapper(impl)
}
