package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.{KmsKeyPolicy, PolicyName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class KmsKeyConfiguration(
    grants: Option[
      Iterable[zio.aws.accessanalyzer.model.KmsGrantConfiguration]
    ] = None,
    keyPolicies: Option[Map[PolicyName, KmsKeyPolicy]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.KmsKeyConfiguration = {
    import KmsKeyConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.KmsKeyConfiguration
      .builder()
      .optionallyWith(
        grants.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.grants)
      .optionallyWith(
        keyPolicies.map(value =>
          value
            .map({ case (key, value) =>
              (PolicyName.unwrap(key): java.lang.String) -> (KmsKeyPolicy
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.keyPolicies)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.KmsKeyConfiguration.ReadOnly =
    zio.aws.accessanalyzer.model.KmsKeyConfiguration.wrap(buildAwsValue())
}
object KmsKeyConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.KmsKeyConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.KmsKeyConfiguration =
      zio.aws.accessanalyzer.model.KmsKeyConfiguration(
        grants.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        keyPolicies.map(value => value)
      )
    def grants: Option[
      List[zio.aws.accessanalyzer.model.KmsGrantConfiguration.ReadOnly]
    ]
    def keyPolicies: Option[Map[PolicyName, KmsKeyPolicy]]
    def getGrants: ZIO[Any, AwsError, List[
      zio.aws.accessanalyzer.model.KmsGrantConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("grants", grants)
    def getKeyPolicies: ZIO[Any, AwsError, Map[PolicyName, KmsKeyPolicy]] =
      AwsError.unwrapOptionField("keyPolicies", keyPolicies)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.KmsKeyConfiguration
  ) extends zio.aws.accessanalyzer.model.KmsKeyConfiguration.ReadOnly {
    override val grants: Option[
      List[zio.aws.accessanalyzer.model.KmsGrantConfiguration.ReadOnly]
    ] = scala
      .Option(impl.grants())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.accessanalyzer.model.KmsGrantConfiguration.wrap(item)
        }.toList
      )
    override val keyPolicies: Option[Map[PolicyName, KmsKeyPolicy]] = scala
      .Option(impl.keyPolicies())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.accessanalyzer.model.primitives.PolicyName(
              key
            ) -> zio.aws.accessanalyzer.model.primitives.KmsKeyPolicy(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.KmsKeyConfiguration
  ): zio.aws.accessanalyzer.model.KmsKeyConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
