package zio.aws.accessanalyzer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetAnalyzedResourceResponse(
    resource: Option[zio.aws.accessanalyzer.model.AnalyzedResource] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.GetAnalyzedResourceResponse = {
    import GetAnalyzedResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.GetAnalyzedResourceResponse
      .builder()
      .optionallyWith(resource.map(value => value.buildAwsValue()))(_.resource)
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.GetAnalyzedResourceResponse.ReadOnly =
    zio.aws.accessanalyzer.model.GetAnalyzedResourceResponse
      .wrap(buildAwsValue())
}
object GetAnalyzedResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.GetAnalyzedResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.GetAnalyzedResourceResponse =
      zio.aws.accessanalyzer.model
        .GetAnalyzedResourceResponse(resource.map(value => value.asEditable))
    def resource: Option[zio.aws.accessanalyzer.model.AnalyzedResource.ReadOnly]
    def getResource: ZIO[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.AnalyzedResource.ReadOnly
    ] = AwsError.unwrapOptionField("resource", resource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.GetAnalyzedResourceResponse
  ) extends zio.aws.accessanalyzer.model.GetAnalyzedResourceResponse.ReadOnly {
    override val resource
        : Option[zio.aws.accessanalyzer.model.AnalyzedResource.ReadOnly] = scala
      .Option(impl.resource())
      .map(value => zio.aws.accessanalyzer.model.AnalyzedResource.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.GetAnalyzedResourceResponse
  ): zio.aws.accessanalyzer.model.GetAnalyzedResourceResponse.ReadOnly =
    new Wrapper(impl)
}
